/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshotsTestCase;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class StoredContractSnapshotsUnitTestCase
extends ContractSnapshotsTestCase {
    @Test
    public void noSlaStoredContractSlaUpdate() {
        Mockito.when((Object)this.mocks.api().getContracts().contracts()).thenReturn(Arrays.asList(this.noSlaContractForClient(null)));
        this.snapshots.slas(this.apiKey(), Arrays.asList(new Sla[0]));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(null)));
    }

    @Test
    public void withSlaStoredContractSlaUpdate() {
        Mockito.when((Object)this.mocks.api().getContracts().contracts()).thenReturn(Arrays.asList(this.contractSingleLimit(1)));
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.contractSingleLimit(1)));
    }

    @Test
    public void noSlaStoredContractClientsUpdate() {
        Mockito.when((Object)this.mocks.api().getContracts().contracts()).thenReturn(Arrays.asList(this.noSlaContractForClient(null)));
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(null)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.noSlaContractForClient(null)));
    }

    @Test
    public void withSlaStoredContractClientsUpdate() {
        Mockito.when((Object)this.mocks.api().getContracts().contracts()).thenReturn(Arrays.asList(this.contractSingleLimit(1)));
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.contractSingleLimit(1)));
    }

    @Test
    public void multipleStoredContractsSlaUpdate() {
        Mockito.when((Object)this.mocks.api().getContracts().contracts()).thenReturn(Arrays.asList(this.contractSingleLimit(1), this.contractSingleLimit(1), this.contractSingleLimit(1902)));
        this.snapshots.slas(this.apiKey(), Arrays.asList(this.sla(1), this.sla(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.contractSingleLimit(1), this.contractSingleLimit(1), this.contractSingleLimit(1902)));
    }

    @Test
    public void multipleStoredContractsClientsUpdate() {
        Mockito.when((Object)this.mocks.api().getContracts().contracts()).thenReturn(Arrays.asList(this.contractSingleLimit(1), this.contractSingleLimit(1), this.contractSingleLimit(1902)));
        this.snapshots.clients(this.apiKey(), Arrays.asList(this.platformContractAdapter(1), this.platformContractAdapter(1), this.platformContractAdapter(1902)));
        this.checkContractsUpdatesAndMockedInvocations(Arrays.asList(this.contractSingleLimit(1), this.contractSingleLimit(1), this.contractSingleLimit(1902)));
    }

    private void checkContractsUpdatesAndMockedInvocations(List<Contract> ... expectedUpdates) {
        ((ApiService)Mockito.verify((Object)this.mocks.apiService(), (VerificationMode)Mockito.times((int)expectedUpdates.length))).getContracts((ApiKey)ArgumentMatchers.eq((Object)this.apiKey()));
        this.checkContractsUpdates(expectedUpdates);
        this.verifyApiTestInvocations();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    private ApiKey apiKey() {
        return PolicyTestValuesConstants.API_KEY;
    }
}

