/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.mule.runtime.gw.deployment.replication.ApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;

/**
 * If Gateway is in offline mode, then deployment of already stored policies will happen as APIs get deployed instead of waiting
 * for API tracking
 */
public class OfflineModeApiDeploymentListener implements ApiDeploymentListener {

  private ApiConfigurationCache apiConfigurationCache;
  private PolicySetDeploymentService policySetDeploymentService;

  public OfflineModeApiDeploymentListener(ApiConfigurationCache apiConfigurationCache,
                                          PolicySetDeploymentService policySetDeploymentService) {
    this.apiConfigurationCache = apiConfigurationCache;
    this.policySetDeploymentService = policySetDeploymentService;
  }

  @Override
  public void onApiDeploymentSuccess(Api api) {
    apiConfigurationCache.getPolicies(api.getKey())
        .ifPresent(policySet -> policySetDeploymentService.policiesForApi(api.getKey(), policySet));
  }

}
