/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.client.dto.SlaDto;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;

import java.util.List;
import java.util.Optional;

/**
 * Defines a Snapshot of Platform's information about {@link Contract}s for an specific {@link ApiContracts}.
 */
public interface Snapshot {

  /**
   * @return the last known {@link Contract}s from Platform.
   */
  Optional<List<Contract>> contracts();

  /**
   * @return the last known {@link Sla}s from Platform.
   */
  Optional<List<Sla>> slas();

  /**
   * Updates the current {@link Snapshot} with new information from Platform about {@link Sla}.
   * 
   * @param platformSlas last {@link SlaDto}s from Platform, adapted to our internal model.
   * @return this
   */
  Snapshot platformSlas(List<Sla> platformSlas);

  /**
   * Updates the current {@link Snapshot} with new information from Platform about {@link Client}.
   * 
   * @param platformContractAdapters last {@link ApiClientDto}s from Platform, adapted to our internal model.
   * @return this
   */
  Snapshot platformContracts(List<PlatformContractAdapter> platformContractAdapters);
}
