/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import static com.mulesoft.mule.runtime.gw.model.PolicySet.PolicySetOrigin.FILE_SYSTEM;
import static java.util.Collections.emptyList;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.Optional.ofNullable;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.MapDBContractRepository;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StandaloneApiConfigurationCache implements ApiConfigurationCache {

  private Map<ApiKey, PolicySet> policySets = new HashMap<>();

  private PolicySetDeploymentService policySetDeploymentService;
  // TODO: AGW-1634: Re think how to detect a first-time deployment
  private ContractRepository contractRepository;

  public StandaloneApiConfigurationCache(PolicySetDeploymentService policySetDeploymentService) {
    this.policySetDeploymentService = policySetDeploymentService;
    this.contractRepository = new MapDBContractRepository();
  }

  @Override
  public void set(ApiKey apiKey, PolicySet policySet, List<Sla> slas) {
    policySets.put(apiKey, policySet);
  }

  @Override
  public void remove(ApiKey apiKey) {
    policySets.remove(apiKey);
  }

  @Override
  public Optional<PolicySet> getPolicies(ApiKey apiKey) {
    if (policySets.containsKey(apiKey)) {
      return ofNullable(policySets.get(apiKey));
    }

    return contractRepository.containsSla(apiKey) ? of(emptySet()) : empty();
  }

  @Override
  public void initialise(ApiTrackingService apiTrackingService) {
    policySetDeploymentService.storedOnlinePoliciesByApi()
        .forEach((apiKey, policyDefinitions) -> policySets.put(apiKey, new PolicySet(policyDefinitions, FILE_SYSTEM)));
  }

  private PolicySet emptySet() {
    return new PolicySet(emptyList(), FILE_SYSTEM);
  }
}
