/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.PlatformClientsRetriever;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;

import org.slf4j.Logger;

public class ClientsRunnable extends GatewayPollerRunnable {

  private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ClientsRunnable.class);

  private final PlatformClientsRetriever retriever;

  public ClientsRunnable(ApiTrackingService apiTrackingService,
                         ApiPlatformSessionFactory platformSessionFactory,
                         BackoffBarrier backoffBarrier,
                         BackoffConfiguration backoffConfiguration,
                         PlatformClientsRetriever retriever) {
    super(apiTrackingService, platformSessionFactory, backoffBarrier, backoffConfiguration);
    this.retriever = retriever;
  }

  @Override
  protected SessionMetadata execute() {
    return profiledExecution(() -> {
      LOGGER.debug("Collecting clients across all APIS");
      return retriever.retrieve(apiTrackingService.getTrackedApisRequiringContracts());
    });
  }
}
