/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.BackoffScheduler;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.PlatformBackoffBarrier;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.PlatformClientsRetriever;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ApiKeepAliveRunnable;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ApisRunnable;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ClientsRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayPollersManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayPollersManager.class);
    private final GatewayConfiguration configuration;
    private final ApiService apiService;
    private final ApiTrackingService apiTrackingService;
    private final ApiPlatformSessionFactory platformSessionFactory;
    private final BackoffSchedulerFactory schedulerFactory;
    private final BackoffConfigurationSupplier backoffConfigurationSupplier;
    private BackoffScheduler schedulerKeepAlive;
    private BackoffScheduler schedulerApis;
    private BackoffScheduler schedulerClients;
    private ApiKeepAliveRunnable keepAliveRunnable;
    private ApisRunnable apisRunnable;
    private ClientsRunnable clientsRunnable;

    public GatewayPollersManager(GatewayConfiguration configuration, ApiService apiService, ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, BackoffSchedulerFactory schedulerFactory, BackoffConfigurationSupplier backoffConfigurationSupplier) {
        this.configuration = configuration;
        this.apiService = apiService;
        this.apiTrackingService = apiTrackingService;
        this.platformSessionFactory = platformSessionFactory;
        this.schedulerFactory = schedulerFactory;
        this.backoffConfigurationSupplier = backoffConfigurationSupplier;
    }

    public BackoffRunnable scheduleKeepAliveRunnable() {
        if (this.schedulerKeepAlive == null) {
            this.schedulerKeepAlive = this.schedulerFactory.create(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("agw-api-keep-alive")));
            this.keepAliveRunnable = new ApiKeepAliveRunnable(this.apiTrackingService, this.platformSessionFactory, this.backoffBarrier(), this.backoffConfiguration());
            this.schedulerKeepAlive.scheduleWithFixedDelay((BackoffRunnable)this.keepAliveRunnable, this.keepAliveConfiguration());
            LOGGER.debug("Keep Alive Runnable started successfully");
        }
        return this.keepAliveRunnable;
    }

    public BackoffRunnable scheduleApisPollerRunnable() {
        if (this.schedulerApis == null) {
            this.schedulerApis = this.schedulerFactory.create(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("agw-policy-polling")));
            this.apisRunnable = new ApisRunnable(this.apiTrackingService, this.platformSessionFactory, this.backoffBarrier(), this.backoffConfiguration());
            this.schedulerApis.scheduleWithFixedDelay((BackoffRunnable)this.apisRunnable, this.apisConfiguration());
            LOGGER.debug("Policies Runnable started successfully");
        }
        return this.apisRunnable;
    }

    public BackoffRunnable scheduleClientsPollerRunnable() {
        if (this.schedulerClients == null) {
            this.schedulerClients = this.schedulerFactory.create(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("agw-contract-polling")));
            PlatformClientsRetriever retriever = new PlatformClientsRetriever(this.platformSessionFactory, this.apiTrackingService);
            this.apiService.addApiContractsListener((ApiContractsListener)retriever);
            this.clientsRunnable = new ClientsRunnable(this.apiTrackingService, this.platformSessionFactory, this.backoffBarrier(), this.backoffConfiguration(), retriever);
            this.schedulerClients.scheduleWithFixedDelay((BackoffRunnable)this.clientsRunnable, this.clientsConfiguration());
            LOGGER.debug("Contracts Runnable started successfully");
        }
        return this.clientsRunnable;
    }

    public void shutdown() {
        this.disposeScheduler(this.schedulerKeepAlive);
        this.disposeScheduler(this.schedulerApis);
        this.disposeScheduler(this.schedulerClients);
    }

    public SchedulingConfiguration keepAliveConfiguration() {
        return SchedulingConfiguration.configuration((Period)Period.seconds((int)0), (Period)this.configuration.platformClient().getApiKeepAliveFrequency());
    }

    public SchedulingConfiguration apisConfiguration() {
        return SchedulingConfiguration.configuration((Period)Period.seconds((int)2), (Period)this.configuration.platformClient().getApisPollFrequency());
    }

    public SchedulingConfiguration clientsConfiguration() {
        return SchedulingConfiguration.configuration((Period)Period.seconds((int)4), (Period)this.configuration.platformClient().getClientsPollFrequency());
    }

    private BackoffBarrier backoffBarrier() {
        return new PlatformBackoffBarrier();
    }

    private BackoffConfiguration backoffConfiguration() {
        return this.backoffConfigurationSupplier.forScheduling(this.configuration);
    }

    private void disposeScheduler(BackoffScheduler scheduler) {
        if (scheduler != null) {
            scheduler.dispose();
        }
    }
}

