/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.factory.VariableExecutorBackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.client.session.factory.RestClientApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.ApiDeploymentCoreExtension;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.GatewayPollersManager;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTracker;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.retry.BackoffRunnableRetrierFactory;
import com.mulesoft.mule.runtime.gw.retry.RunnableRetrier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;

public class PlatformInteractionManager
implements ApiPlatformClientConnectionListener,
Disposable {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiDeploymentCoreExtension.class);
    private final ApiService apiService;
    private final ApiTrackingService apiTrackingService;
    private final ApiPlatformSessionFactory platformSessionFactory;
    private final GatewayConfiguration configuration;
    private final BackoffConfigurationSupplier backoffConfigurationSupplier;
    private final BackoffSchedulerFactory backoffSchedulerFactory;
    private final boolean standaloneOrPrimaryNode;
    private final BackoffRunnableRetrierFactory backoffRunnableRetrierFactory;
    private GatewayPollersManager pollersManager;
    private ApiTracker apiTracker;

    public PlatformInteractionManager(ApiService apiService, ApiTrackingService apiTrackingService, ApiPlatformClient restClient, BackoffConfigurationSupplier backoffConfigurationSupplier, boolean standaloneOrPrimaryNode, BackoffRunnableRetrierFactory backoffRunnableRetrierFactory) {
        this.apiService = apiService;
        this.apiTrackingService = apiTrackingService;
        this.configuration = new GatewayConfiguration();
        this.platformSessionFactory = new RestClientApiPlatformSessionFactory(restClient);
        this.backoffSchedulerFactory = new VariableExecutorBackoffSchedulerFactory();
        this.backoffConfigurationSupplier = backoffConfigurationSupplier;
        this.standaloneOrPrimaryNode = standaloneOrPrimaryNode;
        this.backoffRunnableRetrierFactory = backoffRunnableRetrierFactory;
    }

    public void onClientConnected() {
        this.apiTracker = new ApiTracker(this.apiTrackingService, this.platformSessionFactory, (RunnableRetrier<ApiKey>)this.backoffRunnableRetrierFactory.apiTrackerRetrier());
        this.apiService.addDeploymentListener((ApiDeploymentListener)this.apiTracker);
        this.apiService.getApis().forEach(this.apiTracker::onApiDeploymentSuccess);
        this.pollersManager = new GatewayPollersManager(this.configuration, this.apiService, this.apiTrackingService, this.platformSessionFactory, this.backoffSchedulerFactory, this.backoffConfigurationSupplier);
        LOGGER.debug("Starting API Gateway runnables");
        if (this.standaloneOrPrimaryNode) {
            this.pollersManager.scheduleKeepAliveRunnable();
            this.pollersManager.scheduleApisPollerRunnable();
        }
        this.pollersManager.scheduleClientsPollerRunnable();
    }

    public void primaryNode() {
        this.pollersManager.scheduleKeepAliveRunnable();
        this.pollersManager.scheduleApisPollerRunnable();
    }

    public void dispose() {
        if (this.pollersManager != null) {
            this.pollersManager.shutdown();
        }
        if (this.apiTracker != null) {
            this.apiTracker.dispose();
        }
    }
}

