/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.exception.NormalizedExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.runnable.GatewayPollerRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import org.slf4j.Logger;

public class ApiKeepAliveRunnable
extends GatewayPollerRunnable {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiKeepAliveRunnable.class);
    private static final String PERFORM_KEEP_ALIVE_DESCRIPTION = "perform keep alive request for API";
    private final NormalizedExceptionMessageLogger normalizedLogger = new RecoverableExceptionMessageLogger(LOGGER);

    public ApiKeepAliveRunnable(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration) {
        super(apiTrackingService, platformSessionFactory, backoffBarrier, backoffConfiguration);
    }

    protected SessionMetadata execute() {
        return this.profiledExecution(() -> {
            LOGGER.debug("Collecting sources across all applications");
            ApiPlatformSession platform = this.platformSessionFactory.create();
            this.apiTrackingService.getTrackedApis().forEach(api -> {
                try {
                    if (api.getImplementation().getFlow().getMuleContext().isStarted()) {
                        LOGGER.debug("Activating source for {}", api);
                        platform.activateEndpoint(api.getTrackingInfo().getOrganizationId(), api.getTrackingInfo().getEnvironmentId(), api.getKey().id());
                    }
                }
                catch (NotFoundException e) {
                    this.apiTrackingService.apiUntracked(api.getKey());
                }
                catch (Exception e) {
                    this.normalizedLogger.warn(PERFORM_KEEP_ALIVE_DESCRIPTION, api, (Throwable)e);
                }
                catch (Throwable e) {
                    LOGGER.error(String.format("Error activating API %s. %s", api, ExceptionDescriptor.errorMessage((Throwable)e)), e);
                    throw e;
                }
            });
            return platform.metadata();
        });
    }
}

