/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction;

import static java.util.concurrent.Executors.newScheduledThreadPool;

import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.PlatformBackoffBarrier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GatewayPoller {

  private static final Logger LOGGER = LoggerFactory.getLogger(GatewayPoller.class);
  protected final GatewayConfiguration configuration;
  private final String name;
  private final BackoffSchedulerFactory schedulerFactory;
  private final BackoffConfigurationSupplier backoffConfigurationSupplier;

  private BackoffScheduler scheduler;
  private BackoffRunnable runnable;

  public GatewayPoller(String name,
                       GatewayConfiguration configuration,
                       BackoffSchedulerFactory schedulerFactory,
                       BackoffConfigurationSupplier backoffConfigurationSupplier) {
    this.name = name;
    this.configuration = configuration;
    this.schedulerFactory = schedulerFactory;
    this.backoffConfigurationSupplier = backoffConfigurationSupplier;
  }

  public BackoffRunnable schedule() {
    if (scheduler == null) {
      scheduler = schedulerFactory.create(newScheduledThreadPool(1, new NamedThreadFactory(name)));
      runnable = runnable(backoffBarrier(), backoffConfiguration());
      scheduler.scheduleWithFixedDelay(runnable, configuration());

      LOGGER.debug("{} Runnable started successfully", name);
    }

    return runnable;
  }

  protected abstract BackoffRunnable runnable(BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration);

  public abstract SchedulingConfiguration configuration();

  public void shutdown() {
    if (scheduler != null) {
      scheduler.dispose();
    }
  }

  private BackoffBarrier backoffBarrier() {
    return new PlatformBackoffBarrier();
  }

  private BackoffConfiguration backoffConfiguration() {
    return backoffConfigurationSupplier.forScheduling(configuration.platformClient().getOutagesStatusCodes(),
                                                      configuration.platformClient().backoffEnabled());
  }

}
