/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis;

import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PrimaryPollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.tracking.RetriableApiTracker;

public class ApisPollerPlatformInteractionLifecycle implements ApisPlatformInteractionLifecycle,
    ApiPlatformClientConnectionListener {

  private PrimaryPollerPlatformInteractionLifecycle pollerLifecycle;
  private final ApiService apiService;
  private final RetriableApiTracker apiTracker;

  public ApisPollerPlatformInteractionLifecycle(PrimaryPollerPlatformInteractionLifecycle pollerLifecycle,
                                                ApiService apiService, RetriableApiTracker apiTracker) {
    this.pollerLifecycle = pollerLifecycle;
    this.apiService = apiService;
    this.apiTracker = apiTracker;
  }

  @Override
  public void onClientConnected() {
    apiService.addDeploymentListener(apiTracker);
    apiService.getApis().forEach(apiTracker::onApiDeploymentSuccess);
    pollerLifecycle.onClientConnected();
  }

  @Override
  public void dispose() {
    pollerLifecycle.dispose();
    apiTracker.dispose();
  }

  @Override
  public void primaryNode() {
    pollerLifecycle.primaryNode();
  }
}
