/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.model.PolicySet;

import java.io.Serializable;
import java.util.List;

public class DistributedApiConfigurationEntry implements Serializable {

  private static final long serialVersionUID = 1011455832923916909L;

  private PolicySet policySet;
  private List<Sla> slas;

  public DistributedApiConfigurationEntry(PolicySet policySet, List<Sla> slas) {
    this.policySet = policySet;
    this.slas = slas;
  }

  public PolicySet getPolicySet() {
    return policySet;
  }

  public List<Sla> getSlas() {
    return slas;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    DistributedApiConfigurationEntry that = (DistributedApiConfigurationEntry) o;

    if (policySet != null ? !policySet.equals(that.policySet) : that.policySet != null) {
      return false;
    }
    return slas != null ? slas.equals(that.slas) : that.slas == null;
  }

  @Override
  public int hashCode() {
    int result = policySet != null ? policySet.hashCode() : 0;
    result = 31 * result + (slas != null ? slas.hashCode() : 0);
    return result;
  }
}
