/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import static com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor.errorMessage;
import static java.lang.String.format;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.exception.NormalizedExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;

import org.slf4j.Logger;

public class ApiKeepAliveRunnable extends GatewayPollerRunnable {

  private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiKeepAliveRunnable.class);

  private static final String PERFORM_KEEP_ALIVE_DESCRIPTION = "perform keep alive request for API";

  private final NormalizedExceptionMessageLogger normalizedLogger = new RecoverableExceptionMessageLogger(LOGGER);

  public ApiKeepAliveRunnable(ApiTrackingService apiTrackingService,
                              ApiPlatformSessionFactory platformSessionFactory,
                              BackoffBarrier backoffBarrier,
                              BackoffConfiguration backoffConfiguration) {
    super(apiTrackingService, platformSessionFactory, backoffBarrier, backoffConfiguration);
  }

  @Override
  protected SessionMetadata execute() {
    return profiledExecution(() -> {
      LOGGER.debug("Collecting sources across all applications");

      ApiPlatformSession platform = platformSessionFactory.create();
      apiTrackingService.getTrackedApis().forEach(api -> {
        try {
          if (api.getImplementation().getFlow().getMuleContext().isStarted()) {
            LOGGER.debug("Activating source for {}", api);
            platform.activateEndpoint(api.getTrackingInfo().getOrganizationId(), api.getTrackingInfo().getEnvironmentId(),
                                      api.getKey().id());
          }
        } catch (NotFoundException e) {
          apiTrackingService.apiUntracked(api.getKey());
        } catch (Exception e) {
          normalizedLogger.warn(PERFORM_KEEP_ALIVE_DESCRIPTION, api, e);
        } catch (Throwable e) {
          LOGGER.error(format("Error activating API %s. %s", api, errorMessage(e)), e);
          throw e;
        }
      });

      return platform.metadata();
    });
  }

}
