/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import static java.lang.System.currentTimeMillis;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;

import java.util.function.Supplier;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

//TODO AGW-1567: Backoff - Migrate runnable tests to 4.x
public abstract class GatewayPollerRunnable extends BackoffRunnable {

  private static final Logger LOGGER = LoggerFactory.getLogger(GatewayPollerRunnable.class);

  protected final ApiTrackingService apiTrackingService;
  protected final ApiPlatformSessionFactory platformSessionFactory;

  public GatewayPollerRunnable(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory,
                               BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration) {
    super(backoffConfiguration, backoffBarrier);
    this.platformSessionFactory = platformSessionFactory;
    this.apiTrackingService = apiTrackingService;
  }

  protected SessionMetadata profiledExecution(Supplier<SessionMetadata> sessionMetadataSupplier) {
    int apiCount = 0;
    long startTime = currentTimeMillis();
    try {
      SessionMetadata sessionMetadata = sessionMetadataSupplier.get();
      apiCount = sessionMetadata.requests();
      return sessionMetadata;
    } finally {
      if (LOGGER.isDebugEnabled()) {
        long elapsedTime = currentTimeMillis() - startTime;
        LOGGER.debug("-= {} cycle complete ({} apis - took {}ms)", this.getClass().getSimpleName(), apiCount, elapsedTime);
      }
    }
  }

}
