/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static java.util.Arrays.asList;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;

import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;

import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class StoredContractSnapshotsUnitTestCase extends ContractSnapshotsTestCase {

  @Test
  public void noSlaStoredContractSlaUpdate() {
    when(mocks.api().getContracts().contracts()).thenReturn(asList(noSlaContractForClient(null)));

    snapshots.slas(apiKey(), asList());

    checkContractsUpdatesAndMockedInvocations(asList(noSlaContractForClient(null)));
  }

  @Test
  public void withSlaStoredContractSlaUpdate() {
    when(mocks.api().getContracts().contracts()).thenReturn(asList(contractSingleLimit(SLA_ID)));

    snapshots.slas(apiKey(), asList(sla(SLA_ID)));

    checkContractsUpdatesAndMockedInvocations(asList(contractSingleLimit(SLA_ID)));
  }

  @Test
  public void noSlaStoredContractClientsUpdate() {
    when(mocks.api().getContracts().contracts()).thenReturn(asList(noSlaContractForClient(null)));

    snapshots.clients(apiKey(), asList(platformContractAdapter(null)));

    checkContractsUpdatesAndMockedInvocations(asList(noSlaContractForClient(null)));
  }

  @Test
  public void withSlaStoredContractClientsUpdate() {
    when(mocks.api().getContracts().contracts()).thenReturn(asList(contractSingleLimit(SLA_ID)));

    snapshots.clients(apiKey(), asList(platformContractAdapter(SLA_ID)));

    checkContractsUpdatesAndMockedInvocations(asList(contractSingleLimit(SLA_ID)));
  }

  @Test
  public void multipleStoredContractsSlaUpdate() {
    when(mocks.api().getContracts().contracts())
        .thenReturn(asList(contractSingleLimit(SLA_ID), contractSingleLimit(SLA_ID), contractSingleLimit(ANOTHER_SLA_ID)));

    snapshots.slas(apiKey(), asList(sla(SLA_ID), sla(ANOTHER_SLA_ID)));

    checkContractsUpdatesAndMockedInvocations(asList(contractSingleLimit(SLA_ID),
                                                     contractSingleLimit(SLA_ID),
                                                     contractSingleLimit(ANOTHER_SLA_ID)));
  }

  @Test
  public void multipleStoredContractsClientsUpdate() {
    when(mocks.api().getContracts().contracts())
        .thenReturn(asList(contractSingleLimit(SLA_ID), contractSingleLimit(SLA_ID), contractSingleLimit(ANOTHER_SLA_ID)));

    snapshots.clients(apiKey(), asList(platformContractAdapter(SLA_ID), platformContractAdapter(SLA_ID),
                                       platformContractAdapter(ANOTHER_SLA_ID)));

    checkContractsUpdatesAndMockedInvocations(asList(contractSingleLimit(SLA_ID),
                                                     contractSingleLimit(SLA_ID),
                                                     contractSingleLimit(ANOTHER_SLA_ID)));
  }

  private void checkContractsUpdatesAndMockedInvocations(List<Contract>... expectedUpdates) {
    verify(mocks.apiService(), times(expectedUpdates.length)).getContracts(eq(apiKey()));
    checkContractsUpdates(expectedUpdates);
    verifyApiTestInvocations();
    verifyNoMoreInteractions(mocks.apiTrackingService());
  }

  private ApiKey apiKey() {
    return API_KEY;
  }
}
