/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.pollers;

import static com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration.BACKOFF;
import static com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration.DEFAULT_OUTAGE_STATUS_CODES;
import static com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration.OUTAGE_STATUS_CODES;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKOFF_STEPS;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKON_STEPS;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_FAILURE_PERCENTAGE;
import static java.lang.System.clearProperty;
import static java.lang.System.setProperty;
import static java.util.Arrays.asList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.function.BoundedExponentialFunction;
import com.mulesoft.anypoint.backoff.function.Round;
import com.mulesoft.anypoint.backoff.function.dispersion.RangeDispersant;

import org.junit.Test;

public class BackoffConfigurationTestCase extends GatewayPollersTestCase {

  @Test
  public void defaultIfNotConfigured() {
    BackoffConfiguration configuration = backoffConfigurationBuilder(true).build();

    assertThat(configuration.backoffSteps(), is(DEFAULT_BACKOFF_STEPS));
    assertThat(configuration.backonSteps(), is(DEFAULT_BACKON_STEPS));
    assertThat(configuration.failurePercentage(), is(DEFAULT_FAILURE_PERCENTAGE));
    assertThat(configuration.backoff(), is(defaultBackoffFunction()));
    assertThat(configuration.backon(), is(defaultBackonFunction()));
    assertThat(configuration.statusCodes(), is(DEFAULT_OUTAGE_STATUS_CODES));
  }

  @Test
  public void configureFailurePercentage() {
    BackoffConfiguration configuration = backoffConfigurationBuilder(true).failurePercentage(50).build();

    assertThat(configuration.failurePercentage(), is(50.0));
  }

  @Test
  public void configureStatusCodes() {
    Integer[] statusCodes = {200, 322, 666};
    BackoffConfiguration configuration = backoffConfigurationBuilder(true).statusCodes(statusCodes).build();

    assertThat(configuration.statusCodes(), is(asList(statusCodes)));
  }

  @Test
  public void configureBackoff() {
    BackoffConfiguration configuration = backoffConfigurationBuilder(true).backoff(2, 1.5, 0.33, 15).build();

    assertThat(configuration.backoffSteps(), is(15));
    assertThat(configuration.backoff(),
               is(new Round(new BoundedExponentialFunction(2,
                                                           0, 15,
                                                           1.5,
                                                           new RangeDispersant(0.33, 1.0)))));
    assertThat(configuration.backon(), is(defaultBackonFunction()));
  }

  @Test
  public void configureBackon() {
    BackoffConfiguration configuration = backoffConfigurationBuilder(true).backon(2, 1.5, 0.33, 15).build();

    assertThat(configuration.backonSteps(), is(15));
    assertThat(configuration.backon(),
               is(new Round(new BoundedExponentialFunction(2,
                                                           0, 15,
                                                           1.5,
                                                           new RangeDispersant(0.33, 1.0)))));
    assertThat(configuration.backoff(), is(defaultBackoffFunction()));
  }

  @Test
  public void configurationCanBeDisabled() {
    BackoffConfiguration configuration = backoffConfigurationBuilder(false).build();

    assertThat(configuration.statusCodes(), hasSize(0));
  }

  private BackoffConfiguration.Builder backoffConfigurationBuilder(boolean backoff) {
    return new BackoffConfiguration.Builder(backoff);
  }
}
