/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import static com.google.common.collect.Lists.newArrayList;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static com.mulesoft.mule.runtime.gw.model.PolicySet.PolicySetOrigin.FILE_SYSTEM;
import static com.mulesoft.mule.runtime.gw.reflection.VariableOverride.overrideVariable;
import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Matchers.anyString;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;

import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;

import com.hazelcast.core.IMap;

import java.util.Optional;

import org.junit.Before;
import org.junit.Test;

public class DistributedApiConfigurationCacheTestCase extends AbstractMuleTestCase {

  private static final String API_KEY_AS_STRING = API_KEY.id().toString();

  private ContractRepository contractRepository;

  private DistributedApiConfigurationCache apiConfigurationCache;
  private IMap iMap;
  private HazelcastClusterManager hazelcastManager;

  @Before
  public void setUp() {
    this.contractRepository = mock(ContractRepository.class);
    this.iMap = mock(IMap.class);
    this.hazelcastManager = mock(HazelcastClusterManager.class, RETURNS_DEEP_STUBS);
    PolicySetDeploymentService policySetDeploymentService = mock(PolicySetDeploymentService.class);
    ApiService apiService = mock(ApiService.class);
    ContractSnapshots contractSnapshots = mock(ContractSnapshots.class);

    when(hazelcastManager.getHazelcastInstance().getMap(anyString())).thenReturn(iMap);

    this.apiConfigurationCache = new DistributedApiConfigurationCache(apiService, policySetDeploymentService, contractSnapshots,
                                                                      hazelcastManager);

    overrideVariable("contractRepository").in(apiConfigurationCache).with(contractRepository);
  }

  @Test
  public void getPolicySet() throws InitialisationException {
    PolicyDefinition policyDefinition = mock(PolicyDefinition.class);
    DistributedApiConfigurationEntry entry =
        new DistributedApiConfigurationEntry(new PolicySet(newArrayList(policyDefinition), FILE_SYSTEM), emptyList());
    when(iMap.get(API_KEY_AS_STRING)).thenReturn(entry);
    when(iMap.containsKey(API_KEY_AS_STRING)).thenReturn(true);

    Optional<PolicySet> policySet = apiConfigurationCache.getPolicies(API_KEY);

    assertThat(policySet.isPresent(), is(true));
    assertThat(policySet.get().isFromPlatform(), is(false));
    assertThat(policySet.get().getPolicyDefinitions(), hasSize(1));
    assertThat(policySet.get().getPolicyDefinitions(), hasItems(policyDefinition));
  }

  @Test
  public void getEmptySet() throws InitialisationException {
    when(iMap.containsKey(API_KEY)).thenReturn(false);
    when(contractRepository.containsSla(API_KEY)).thenReturn(true);

    Optional<PolicySet> policySet = apiConfigurationCache.getPolicies(API_KEY);

    assertThat(policySet.isPresent(), is(true));
    assertThat(policySet.get().isFromPlatform(), is(false));
    assertThat(policySet.get().getPolicyDefinitions(), empty());
  }

  @Test
  public void getEmpty() throws InitialisationException {
    when(iMap.containsKey(API_KEY)).thenReturn(false);
    when(contractRepository.containsSla(API_KEY)).thenReturn(false);

    Optional<PolicySet> policySet = apiConfigurationCache.getPolicies(API_KEY);

    assertThat(policySet.isPresent(), is(false));
  }

  @Test
  public void remove() {
    apiConfigurationCache.remove(API_KEY);

    verify(iMap).remove(API_KEY_AS_STRING);
    verifyNoMoreInteractions(iMap);
    verify(hazelcastManager, times(2)).getHazelcastInstance();
    verify(hazelcastManager, times(1)).getClusterId();
    verifyNoMoreInteractions(hazelcastManager);
  }
}
