/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import static com.google.common.collect.Lists.newArrayList;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static com.mulesoft.mule.runtime.gw.reflection.VariableOverride.overrideVariable;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.mule.runtime.api.lifecycle.InitialisationException;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;

import com.google.common.collect.ImmutableMap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.junit.Before;
import org.junit.Test;

public class StandaloneApiConfigurationCacheTestCase {

  private PolicySetDeploymentService policySetDeploymentService;
  private ContractRepository contractRepository;

  private StandaloneApiConfigurationCache apiConfigurationCache;

  @Before
  public void setUp() {
    this.policySetDeploymentService = mock(PolicySetDeploymentService.class);
    this.contractRepository = mock(ContractRepository.class);

    this.apiConfigurationCache = new StandaloneApiConfigurationCache(policySetDeploymentService);

    overrideVariable("contractRepository").in(apiConfigurationCache).with(contractRepository);
  }

  @Test
  public void getPolicySet() throws InitialisationException {
    PolicyDefinition policyDefinition = setDeploymentServiceWithPolicy();

    Optional<PolicySet> policySet = initializeCache().getPolicies(API_KEY);

    assertThat(policySet.isPresent(), is(true));
    assertThat(policySet.get().isFromPlatform(), is(false));
    assertThat(policySet.get().getPolicyDefinitions(), hasSize(1));
    assertThat(policySet.get().getPolicyDefinitions(), hasItems(policyDefinition));
  }

  @Test
  public void getEmptySet() throws InitialisationException {
    when(policySetDeploymentService.storedOnlinePoliciesByApi()).thenReturn(new HashMap<>());
    when(contractRepository.containsSla(API_KEY)).thenReturn(true);

    Optional<PolicySet> policySet = initializeCache().getPolicies(API_KEY);

    assertThat(policySet.isPresent(), is(true));
    assertThat(policySet.get().isFromPlatform(), is(false));
    assertThat(policySet.get().getPolicyDefinitions(), empty());
  }

  @Test
  public void getEmpty() throws InitialisationException {
    when(policySetDeploymentService.storedOnlinePoliciesByApi()).thenReturn(new HashMap<>());
    when(contractRepository.containsSla(API_KEY)).thenReturn(false);

    Optional<PolicySet> policySet = initializeCache().getPolicies(API_KEY);

    assertThat(policySet.isPresent(), is(false));
  }

  @Test
  public void remove() throws InitialisationException {
    setDeploymentServiceWithPolicy();

    initializeCache().remove(API_KEY);

    assertThat(apiConfigurationCache.getPolicies(API_KEY), is(Optional.empty()));
  }

  private StandaloneApiConfigurationCache initializeCache() {
    apiConfigurationCache.initialise(mock(ApiTrackingService.class));
    return apiConfigurationCache;
  }

  private PolicyDefinition setDeploymentServiceWithPolicy() {
    PolicyDefinition policyDefinition = mock(PolicyDefinition.class);
    Map<ApiKey, List<PolicyDefinition>> storedPolicies = ImmutableMap.of(API_KEY, newArrayList(policyDefinition));
    when(policySetDeploymentService.storedOnlinePoliciesByApi()).thenReturn(storedPolicies);
    return policyDefinition;
  }
}
