/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.apis;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.logger.WarnLine;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.IncompatibleApiException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.deployment.ApiPlatformTestCase;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ApisRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

@RunWith(value=MockitoJUnitRunner.class)
public class ApisRunnableTestCase
extends ApiPlatformTestCase {
    @Mock
    private PolicySet policySet;
    @Mock
    private Sla sla;
    @Mock
    private TrackingInfo trackingInfo;
    private ApisRunnable runnable;
    private MockLogger logger;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.runnable = this.mocks.apisRunnable();
        this.logger = new MockLogger();
        VariableOverride.overrideLogger().in((Object)this.runnable).with((Object)this.logger);
        VariableOverride.overrideVariable((String)"normalizedLogger").in((Object)this.runnable).with((Object)new RecoverableExceptionMessageLogger((Logger)this.logger));
    }

    @Test
    public void oneApiPolled() {
        ArrayList slas = Lists.newArrayList((Object[])new Sla[]{this.sla});
        ApiResponse apiResponse = new ApiResponse(this.trackingInfo, this.policySet, (List)slas, true);
        this.mocks.singleTrackedApi().getApiReturns(this.mocks.api(), apiResponse);
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.api());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).apiTracked(PolicyTestValuesConstants.API_KEY, this.trackingInfo, this.policySet, (List)slas);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void oneIncompatibleApi() {
        IncompatibleApiException exception = new IncompatibleApiException("");
        this.mocks.singleTrackedApi().getApiThrows(this.mocks.api(), (Exception)exception);
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.api());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new WarnLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"retrieve API information for API", this.mocks.api(), ExceptionDescriptor.errorMessage((Throwable)exception)})), (Matcher)Is.is((Object)true));
    }

    @Test
    public void connectionErrorGettingApi() {
        HttpConnectionException exception = new HttpConnectionException("message", null);
        this.mocks.singleTrackedApi().getApiThrows(this.mocks.api(), (Exception)exception);
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.api());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new WarnLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"retrieve API information for API", this.mocks.api(), ExceptionDescriptor.errorMessage((Throwable)exception)})), (Matcher)Is.is((Object)true));
    }

    @Test
    public void noApisPolled() {
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session(), (VerificationMode)Mockito.never())).getApi((Api)Matchers.any(Api.class));
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void multipleApisPolled() {
        ArrayList slas = Lists.newArrayList((Object[])new Sla[]{this.sla});
        ApiResponse apiResponse = new ApiResponse(this.trackingInfo, this.policySet, (List)slas, true);
        this.mocks.multipleTrackedApis().getApiReturns(this.mocks.api(), apiResponse).getApiReturns(this.mocks.secondApi(), apiResponse);
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.api());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.secondApi());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).apiTracked(PolicyTestValuesConstants.API_KEY, this.trackingInfo, this.policySet, (List)slas);
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).apiTracked(PolicyTestValuesConstants.API_KEY_2, this.trackingInfo, this.policySet, (List)slas);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void policiesAreUntouchedIfNoUpdatesResponse() {
        ArrayList slas = Lists.newArrayList((Object[])new Sla[]{this.sla});
        ApiResponse apiResponse = new ApiResponse(this.trackingInfo, this.policySet, (List)slas, false);
        this.mocks.singleTrackedApi().getApiReturns(this.mocks.api(), apiResponse);
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.api());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void errorWhenRequestingPoliciesDoesNotBlocksOtherAPIs() {
        ArrayList slas = Lists.newArrayList((Object[])new Sla[]{this.sla});
        ApiResponse apiResponse = new ApiResponse(this.trackingInfo, this.policySet, (List)slas, true);
        HttpResponseException exception = new HttpResponseException("");
        this.mocks.multipleTrackedApis().getApiThrows(this.mocks.api(), (Exception)exception).getApiReturns(this.mocks.secondApi(), apiResponse);
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.api());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.secondApi());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).apiTracked((ApiKey)Matchers.eq((Object)PolicyTestValuesConstants.API_KEY_2), (TrackingInfo)Matchers.any(), (PolicySet)Matchers.any(), (List)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new WarnLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"retrieve API information for API", this.mocks.api(), ExceptionDescriptor.errorMessage((Throwable)exception)})), (Matcher)Is.is((Object)true));
    }

    @Test
    public void runDeletedApiFromPlatform() {
        this.mocks.singleTrackedApi().getApiThrows(this.mocks.api(), (Exception)new NotFoundException(""));
        this.runnable.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApi(this.mocks.api());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApis();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).apiUntracked(PolicyTestValuesConstants.API_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }
}

