/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.logger.WarnLine;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiClientsResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.deployment.ApiPlatformTestCase;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ClientsRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class ContractSnapshotsRunnablesTestCase
extends ApiPlatformTestCase {
    private ClientsRunnable runnable;
    private MockLogger logger;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.runnable = this.mocks.clientsRunnable();
        this.logger = new MockLogger();
        VariableOverride.overrideLogger().in((Object)this.runnable).with((Object)this.logger);
        VariableOverride.overrideVariable((String)"retriever.normalizedLogger").in((Object)this.runnable).with((Object)new RecoverableExceptionMessageLogger((Logger)this.logger));
    }

    @Test
    public void noClients() throws IOException, URISyntaxException {
        ApiClientsResponse apiClientsResponse = this.apiClientsResponse(this.mocks.api(), Collections.emptyList());
        this.mocks.singleApiFetchContracts().getApiClientsReturns(this.mocks.api(), apiClientsResponse);
        this.runnable.run();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApisRequiringContracts();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).clientsPolling(this.mocks.api().getKey(), Collections.emptyList(), apiClientsResponse.getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.api().getTrackingInfo().getOrganizationId(), this.mocks.api().getTrackingInfo().getEnvironmentId(), this.mocks.api().getTrackingInfo().getId(), this.mocks.api().getTrackingInfo().getContractsEntityTag());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void oneClient() throws IOException {
        ApiClientDto client = this.apiClient(0, 1);
        ApiClientsResponse apiClientsResponse = this.apiClientsResponse(this.mocks.api(), Collections.singletonList(client));
        this.mocks.singleApiFetchContracts().getApiClientsReturns(this.mocks.api(), apiClientsResponse);
        this.runnable.run();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApisRequiringContracts();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).clientsPolling(this.mocks.api().getKey(), Collections.singletonList(new PlatformContractAdapter(client)), apiClientsResponse.getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.api().getTrackingInfo().getOrganizationId(), this.mocks.api().getTrackingInfo().getEnvironmentId(), this.mocks.api().getTrackingInfo().getId(), this.mocks.api().getTrackingInfo().getContractsEntityTag());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void multipleClients() throws IOException {
        ApiClientDto client = this.apiClient(0, 1);
        ApiClientDto client2 = this.apiClient(1, 1902);
        ApiClientsResponse apiClientsResponse = this.apiClientsResponse(this.mocks.api(), Arrays.asList(client, client2));
        this.mocks.singleApiFetchContracts().getApiClientsReturns(this.mocks.api(), apiClientsResponse);
        this.runnable.run();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApisRequiringContracts();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).clientsPolling(this.mocks.api().getKey(), Arrays.asList(new PlatformContractAdapter(client), new PlatformContractAdapter(client2)), apiClientsResponse.getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.api().getTrackingInfo().getOrganizationId(), this.mocks.api().getTrackingInfo().getEnvironmentId(), this.mocks.api().getTrackingInfo().getId(), this.mocks.api().getTrackingInfo().getContractsEntityTag());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void notFetchingContracts() throws IOException {
        this.mocks.singleTrackedApi();
        this.runnable.run();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApisRequiringContracts();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session(), (VerificationMode)Mockito.never())).getApiClients((String)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any(), (Long)org.mockito.Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void multipleApisFetchingContracts() throws IOException {
        ApiClientDto client = this.apiClient(0, 1);
        ApiClientsResponse apiClientsResponse = this.apiClientsResponse(this.mocks.api(), Collections.singletonList(client));
        ApiClientsResponse secondApiClientsResponse = this.apiClientsResponse(this.mocks.secondApi(), Collections.singletonList(client));
        this.mocks.multipleApisFetchContracts().getApiClientsReturns(this.mocks.api(), apiClientsResponse).getApiClientsReturns(this.mocks.secondApi(), secondApiClientsResponse);
        this.runnable.run();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApisRequiringContracts();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).clientsPolling(this.mocks.api().getKey(), Collections.singletonList(new PlatformContractAdapter(client)), apiClientsResponse.getContractsEntityTag());
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).clientsPolling(this.mocks.secondApi().getKey(), Collections.singletonList(new PlatformContractAdapter(client)), secondApiClientsResponse.getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.api().getTrackingInfo().getOrganizationId(), this.mocks.api().getTrackingInfo().getEnvironmentId(), this.mocks.api().getTrackingInfo().getId(), this.mocks.api().getTrackingInfo().getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.secondApi().getTrackingInfo().getOrganizationId(), this.mocks.secondApi().getTrackingInfo().getEnvironmentId(), this.mocks.secondApi().getTrackingInfo().getId(), this.mocks.secondApi().getTrackingInfo().getContractsEntityTag());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
    }

    @Test
    public void processAllAPIsDespiteGetApiClientFailing() throws IOException {
        ApiClientDto client = this.apiClient(0, 1);
        HttpResponseException exception = new HttpResponseException("");
        ApiClientsResponse secondApiClientsResponse = this.apiClientsResponse(this.mocks.secondApi(), Collections.singletonList(client));
        this.mocks.multipleApisFetchContracts().getApiClientsThrows(this.mocks.api(), (Exception)exception).getApiClientsReturns(this.mocks.secondApi(), secondApiClientsResponse);
        this.runnable.run();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApisRequiringContracts();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).clientsPolling(this.mocks.secondApi().getKey(), Collections.singletonList(new PlatformContractAdapter(client)), secondApiClientsResponse.getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.api().getTrackingInfo().getOrganizationId(), this.mocks.api().getTrackingInfo().getEnvironmentId(), this.mocks.api().getTrackingInfo().getId(), this.mocks.api().getTrackingInfo().getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.secondApi().getTrackingInfo().getOrganizationId(), this.mocks.secondApi().getTrackingInfo().getEnvironmentId(), this.mocks.secondApi().getTrackingInfo().getId(), this.mocks.secondApi().getTrackingInfo().getContractsEntityTag());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new WarnLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"obtain contracts for API", this.mocks.api(), ExceptionDescriptor.errorMessage((Throwable)exception)})), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void processAllAPIsDespiteGetApiClientConnectionFailing() throws IOException {
        ApiClientDto client = this.apiClient(0, 1);
        HttpConnectionException exception = new HttpConnectionException("message", null);
        ApiClientsResponse secondApiClientsResponse = this.apiClientsResponse(this.mocks.secondApi(), Collections.singletonList(client));
        this.mocks.multipleApisFetchContracts().getApiClientsThrows(this.mocks.api(), (Exception)exception).getApiClientsReturns(this.mocks.secondApi(), secondApiClientsResponse);
        this.runnable.run();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).getTrackedApisRequiringContracts();
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).clientsPolling(this.mocks.secondApi().getKey(), Collections.singletonList(new PlatformContractAdapter(client)), secondApiClientsResponse.getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.api().getTrackingInfo().getOrganizationId(), this.mocks.api().getTrackingInfo().getEnvironmentId(), this.mocks.api().getTrackingInfo().getId(), this.mocks.api().getTrackingInfo().getContractsEntityTag());
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).getApiClients(this.mocks.secondApi().getTrackingInfo().getOrganizationId(), this.mocks.secondApi().getTrackingInfo().getEnvironmentId(), this.mocks.secondApi().getTrackingInfo().getId(), this.mocks.secondApi().getTrackingInfo().getContractsEntityTag());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.apiTrackingService()});
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new WarnLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"obtain contracts for API", this.mocks.api(), ExceptionDescriptor.errorMessage((Throwable)exception)})), (Matcher)Matchers.is((Object)true));
    }

    private ApiClientDto apiClient(int id, int slaId) {
        return this.dtoClient(id, this.mocks.api().getTrackingInfo().getId(), String.valueOf(slaId));
    }

    private ApiClientsResponse apiClientsResponse(Api api, List<ApiClientDto> clients) {
        return new ApiClientsResponseBuilder().withClients(clients).withContractsEntityTag("aContractsEntityTag" + api.getKey().id()).build();
    }
}

