/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.keep.alive;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.logger.WarnLine;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.deployment.ApiPlatformTestCase;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ApiKeepAliveRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.io.IOException;
import java.net.URISyntaxException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class ApiKeepAliveRunnableTestCase
extends ApiPlatformTestCase {
    private ApiKeepAliveRunnable instance;
    private MockLogger logger;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.instance = this.mocks.keepAliveRunnable();
        this.logger = new MockLogger();
        VariableOverride.overrideLogger().in((Object)this.instance).with((Object)this.logger);
        VariableOverride.overrideVariable((String)"normalizedLogger").in((Object)this.instance).with((Object)new RecoverableExceptionMessageLogger((Logger)this.logger));
    }

    @Test
    public void runCompletesSuccessfully() throws IOException {
        this.mocks.singleTrackedApi();
        this.instance.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID);
        this.verifyRemainingSessionInteractions();
    }

    @Test
    public void runCompletesSuccessfullyMultipleApis() throws IOException {
        this.mocks.multipleTrackedApis();
        this.instance.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID);
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID_2);
        this.verifyRemainingSessionInteractions();
    }

    @Test
    public void runNoEndpointToActivate() throws IOException {
        this.mocks.singleTrackedApi().stoppedApi();
        this.instance.run();
        this.verifyRemainingSessionInteractions();
    }

    @Test
    public void runThrowsException() throws IOException {
        ((ApiPlatformSession)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.mocks.session())).activateEndpoint((String)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any(), (Long)org.mockito.Matchers.any());
        this.instance.run();
        this.verifyRemainingSessionInteractions();
    }

    @Test
    public void exceptionForAnApiDoesNotBlocksOtherApis() throws IOException, URISyntaxException {
        this.mocks.multipleTrackedApis();
        ((ApiPlatformSession)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.mocks.session())).activateEndpoint((String)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any(), (Long)org.mockito.Matchers.eq((Object)PolicyTestValuesConstants.API_ID));
        this.instance.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID);
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID_2);
        this.verifyRemainingSessionInteractions();
    }

    @Test
    public void runDeletedApiFromPlatform() throws IOException, URISyntaxException {
        this.mocks.singleTrackedApi();
        ((ApiPlatformSession)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException("")}).when((Object)this.mocks.session())).activateEndpoint((String)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any(), (Long)org.mockito.Matchers.any());
        this.instance.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID);
        ((ApiTrackingService)Mockito.verify((Object)this.mocks.apiTrackingService())).apiUntracked(PolicyTestValuesConstants.API_KEY);
        this.verifyRemainingSessionInteractions();
    }

    @Test
    public void unsuccessfulResponseWhenConnectingToPlatform() {
        this.mocks.singleTrackedApi();
        HttpResponseException e = new HttpResponseException("");
        ((ApiPlatformSession)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)this.mocks.session())).activateEndpoint((String)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any(), (Long)org.mockito.Matchers.eq((Object)PolicyTestValuesConstants.API_ID));
        this.instance.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID);
        this.verifyRemainingSessionInteractions();
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new WarnLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"perform keep alive request for API", this.mocks.api(), ExceptionDescriptor.errorMessage((Throwable)e)})), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void connectionErrorConnectingToPlatform() {
        this.mocks.singleTrackedApi();
        HttpConnectionException e = new HttpConnectionException("message", null);
        ((ApiPlatformSession)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)this.mocks.session())).activateEndpoint((String)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any(), (Long)org.mockito.Matchers.eq((Object)PolicyTestValuesConstants.API_ID));
        this.instance.run();
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).activateEndpoint("orgId", "envId", PolicyTestValuesConstants.API_ID);
        this.verifyRemainingSessionInteractions();
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new WarnLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"perform keep alive request for API", this.mocks.api(), ExceptionDescriptor.errorMessage((Throwable)e)})), (Matcher)Matchers.is((Object)true));
    }

    private void verifyRemainingSessionInteractions() {
        ((ApiPlatformSession)Mockito.verify((Object)this.mocks.session())).metadata();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.session()});
    }
}

