/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.pollers;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.GatewayPoller;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.GatewayApisPoller;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.GatewayClientsPoller;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.PlatformClientsRetriever;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.GatewayKeepAlivePoller;
import com.mulesoft.mule.runtime.gw.deployment.pollers.GatewayPollersTestCase;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class GatewayPollerTestCase
extends GatewayPollersTestCase {
    private Function<BackoffSchedulerFactory, GatewayPoller> pollerManagerSupplier;
    private GatewayPoller pollerManager;
    private BackoffScheduler scheduler;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({factory -> new GatewayApisPoller(new GatewayConfiguration(), (ApiTrackingService)Mockito.mock(ApiTrackingService.class), (ApiPlatformSessionFactory)Mockito.mock(ApiPlatformSessionFactory.class), factory, new BackoffConfigurationSupplier())}, {factory -> new GatewayKeepAlivePoller(new GatewayConfiguration(), (ApiTrackingService)Mockito.mock(ApiTrackingService.class), (ApiPlatformSessionFactory)Mockito.mock(ApiPlatformSessionFactory.class), factory, new BackoffConfigurationSupplier())}, {factory -> new GatewayClientsPoller(new GatewayConfiguration(), (ApiTrackingService)Mockito.mock(ApiTrackingService.class), (ApiPlatformSessionFactory)Mockito.mock(ApiPlatformSessionFactory.class), factory, new BackoffConfigurationSupplier(), (PlatformClientsRetriever)Mockito.mock(PlatformClientsRetriever.class))});
    }

    public GatewayPollerTestCase(Function<BackoffSchedulerFactory, GatewayPoller> pollerManagerSupplier) {
        this.pollerManagerSupplier = pollerManagerSupplier;
    }

    @Override
    public void setUp() {
        super.setUp();
        BackoffSchedulerFactory factory = (BackoffSchedulerFactory)Mockito.mock(BackoffSchedulerFactory.class);
        this.scheduler = (BackoffScheduler)Mockito.mock(BackoffScheduler.class);
        Mockito.when((Object)factory.create((ScheduledExecutorService)org.mockito.Matchers.any())).thenReturn((Object)this.scheduler);
        this.pollerManager = this.pollerManagerSupplier.apply(factory);
    }

    @Test
    public void runnablesWithDefaultStatusCodes() {
        MatcherAssert.assertThat((Object)this.configuration(this.pollerManager.schedule()).statusCodes(), (Matcher)Matchers.is((Object)PlatformClientConfiguration.DEFAULT_OUTAGE_STATUS_CODES));
    }

    @Test
    public void runnablesWithCustomStatusCodes() {
        List<Integer> configuredStatusCodes = Arrays.asList(522, 429, 666);
        System.setProperty("anypoint.platform.outage_status_codes", "522, 429, 666");
        MatcherAssert.assertThat((Object)this.configuration(this.pollerManager.schedule()).statusCodes(), (Matcher)Matchers.is(configuredStatusCodes));
    }

    @Test
    public void runnablesBackoffConfiguration() {
        this.assertDefault(this.configuration(this.pollerManager.schedule()));
    }

    @Test
    public void shutdownWhenPollerNotStarted() {
        this.pollerManager.shutdown();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.scheduler});
    }

    @Test
    public void shutdownWhenDisposed() {
        this.pollerManager.schedule();
        this.pollerManager.shutdown();
        ((BackoffScheduler)Mockito.verify((Object)this.scheduler)).dispose();
    }

    private void assertDefault(BackoffConfiguration configuration) {
        MatcherAssert.assertThat((Object)configuration.backoffSteps(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)configuration.backonSteps(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)configuration.failurePercentage(), (Matcher)Matchers.is((Object)100.0));
        MatcherAssert.assertThat((Object)configuration.backoff(), (Matcher)Matchers.is((Object)this.defaultBackoffFunction()));
        MatcherAssert.assertThat((Object)configuration.backon(), (Matcher)Matchers.is((Object)this.defaultBackonFunction()));
        MatcherAssert.assertThat((Object)configuration.statusCodes(), (Matcher)Matchers.is((Object)PlatformClientConfiguration.DEFAULT_OUTAGE_STATUS_CODES));
    }

    private BackoffConfiguration configuration(BackoffRunnable pollerRunnable) {
        return (BackoffConfiguration)new Inspector((Object)pollerRunnable).read("currentState.configuration");
    }
}

