/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.ErrorLine;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.IncompatibleApiException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTracker;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.RetriableApiTracker;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.Logger;

@RunWith(value=MockitoJUnitRunner.class)
public class RetriableApiTrackerTestCase
extends AbstractMuleTestCase {
    @Mock
    private ApiTrackingService apiTrackingService;
    @Mock
    private RunnableRetrier<ApiKey> runnableRetrier;
    @Mock
    private ApiPlatformSessionFactory sessionFactory;
    @Mock
    private ApiPlatformSession session;
    @Mock
    private ApiImplementation implementation;
    @Mock
    private Api api;
    private RetriableApiTracker apiTracker;
    private MockLogger logger;

    @Before
    public void setUp() {
        ApiTracker tracker = new ApiTracker(this.apiTrackingService, this.sessionFactory);
        this.apiTracker = new RetriableApiTracker(tracker, this.runnableRetrier);
        Mockito.when((Object)this.sessionFactory.create()).thenReturn((Object)this.session);
        Mockito.when((Object)this.implementation.getApiKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)this.implementation);
        this.logger = new MockLogger();
        VariableOverride.overrideLogger().in((Object)tracker).with((Object)this.logger);
        VariableOverride.overrideVariable((String)"normalizedLogger").in((Object)tracker).with((Object)new RecoverableExceptionMessageLogger((Logger)this.logger));
    }

    @Test
    public void success() {
        TrackingInfo trackingInfo = (TrackingInfo)Mockito.mock(TrackingInfo.class);
        PolicySet policySet = (PolicySet)Mockito.mock(PolicySet.class);
        ArrayList slas = Lists.newArrayList((Object[])new Sla[]{(Sla)Mockito.mock(Sla.class)});
        ApiResponse apiResponse = new ApiResponse(trackingInfo, policySet, (List)slas, true);
        Mockito.when((Object)this.session.getApi((ApiKey)org.mockito.Matchers.any(ApiKey.class))).thenReturn((Object)apiResponse);
        this.apiTracker.onApiDeploymentSuccess(this.api);
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiTracked(PolicyTestValuesConstants.API_KEY, trackingInfo, policySet, (List)slas);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.runnableRetrier});
    }

    @Test
    public void incompatibleApi() throws IOException {
        IncompatibleApiException exception = new IncompatibleApiException("");
        Mockito.when((Object)this.session.getApi((ApiKey)org.mockito.Matchers.any(ApiKey.class))).thenThrow(new Throwable[]{exception});
        this.apiTracker.onApiDeploymentSuccess(this.api);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.runnableRetrier, this.apiTrackingService});
        MatcherAssert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.logger.lines().get(1), (Matcher)Is.is((Object)new ErrorLine("There was an error trying to track API {}. {}", new Object[]{1L, "Reason: " + exception})));
    }

    @Test
    public void apiNotFound() {
        Mockito.when((Object)this.session.getApi(PolicyTestValuesConstants.API_KEY)).thenThrow(new Throwable[]{new NotFoundException("")});
        this.apiTracker.onApiDeploymentSuccess(this.api);
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiUntracked(PolicyTestValuesConstants.API_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.runnableRetrier});
    }

    @Test
    public void retryIsScheduledAfterFailure() {
        HttpResponseException exception = new HttpResponseException("");
        Mockito.when((Object)this.session.getApi(PolicyTestValuesConstants.API_KEY)).thenThrow(new Throwable[]{exception});
        this.apiTracker.onApiDeploymentSuccess(this.api);
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiTrackingFailed(PolicyTestValuesConstants.API_KEY);
        ((RunnableRetrier)Mockito.verify(this.runnableRetrier)).scheduleRetry(org.mockito.Matchers.any(), (Runnable)org.mockito.Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new ErrorLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"retrieve API information for API", PolicyTestValuesConstants.API_KEY.id(), ExceptionDescriptor.errorMessage((Throwable)exception)})), (Matcher)Is.is((Object)true));
    }

    @Test
    public void retryIsScheduledAfterConnectionFailure() {
        HttpConnectionException exception = new HttpConnectionException("message", null);
        Mockito.when((Object)this.session.getApi(PolicyTestValuesConstants.API_KEY)).thenThrow(new Throwable[]{exception});
        this.apiTracker.onApiDeploymentSuccess(this.api);
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiTrackingFailed(PolicyTestValuesConstants.API_KEY);
        ((RunnableRetrier)Mockito.verify(this.runnableRetrier)).scheduleRetry(org.mockito.Matchers.any(), (Runnable)org.mockito.Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
        MatcherAssert.assertThat((Object)this.logger.lines().contains(new ErrorLine("Failed to {} '{}'. This request will be retried after some backoff time. {}", new Object[]{"retrieve API information for API", PolicyTestValuesConstants.API_KEY.id(), ExceptionDescriptor.errorMessage((Throwable)exception)})), (Matcher)Is.is((Object)true));
    }

    @Test
    public void retryIsScheduledAfterError() {
        Mockito.when((Object)this.session.getApi(PolicyTestValuesConstants.API_KEY)).thenThrow(new Throwable[]{new InternalError()});
        this.apiTracker.onApiDeploymentSuccess(this.api);
        ((ApiTrackingService)Mockito.verify((Object)this.apiTrackingService)).apiTrackingFailed(PolicyTestValuesConstants.API_KEY);
        ((RunnableRetrier)Mockito.verify(this.runnableRetrier)).scheduleRetry(org.mockito.Matchers.any(), (Runnable)org.mockito.Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.apiTrackingService});
    }
}

