/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.client.response.PlatformResponse;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionServicesLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionServicesLifecycleFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.model.contracts.ApiContractsFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import com.mulesoft.mule.runtime.gw.retry.BackoffRunnableRetrierFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PlatformInteractionServicesLifecycleTestCase {
    public static final String KEEP_ALIVE_POLL_NAME = "agw-api-keep-alive";
    public static final String CONTRACT_POLL_NAME = "agw-contract-polling";
    public static final String POLICY_POLL_NAME = "agw-policy-polling";
    public static final String CLIENT_ID = "anypoint.platform.client_id";
    public static final String CLIENT_SECRET = "anypoint.platform.client_secret";
    private ApiService apiService;
    private Api api1;
    private Api api2;
    private Api api3;
    private BackoffSchedulerFactory schedulerFactory;
    private ApiPlatformClient restClient;
    private BackoffRunnableRetrierFactory backoffRunnableRetrierFactory;
    private BackoffConfigurationSupplier backoffConfigurationSupplier;
    private ApiTrackingService apiTrackingService;
    private PolicyDeploymentTracker policyDeploymentTracker;
    private MockLogger logger;
    private RunnableRetrier runnableRetrier;

    @Before
    public void setUp() {
        this.api1 = this.api(1L);
        this.api2 = this.api(2L);
        this.api3 = this.api(3L);
        this.apiService = (ApiService)Mockito.mock(ApiService.class);
        Mockito.when((Object)this.apiService.getApis()).thenReturn(Arrays.asList(this.api1, this.api2, this.api3));
        this.schedulerFactory = (BackoffSchedulerFactory)Mockito.mock(BackoffSchedulerFactory.class);
        Mockito.when((Object)this.schedulerFactory.create((ScheduledExecutorService)org.mockito.Matchers.any())).thenReturn(Mockito.mock(BackoffScheduler.class));
        this.restClient = (ApiPlatformClient)Mockito.mock(ApiPlatformClient.class);
        this.apiTrackingService = (ApiTrackingService)Mockito.mock(ApiTrackingService.class);
        this.policyDeploymentTracker = (PolicyDeploymentTracker)Mockito.mock(PolicyDeploymentTracker.class);
        this.backoffConfigurationSupplier = (BackoffConfigurationSupplier)Mockito.mock(BackoffConfigurationSupplier.class);
        this.backoffRunnableRetrierFactory = (BackoffRunnableRetrierFactory)Mockito.mock(BackoffRunnableRetrierFactory.class);
        this.runnableRetrier = (RunnableRetrier)Mockito.mock(RunnableRetrier.class);
        Mockito.when((Object)this.backoffRunnableRetrierFactory.apiTrackerRetrier()).thenReturn((Object)this.runnableRetrier);
        this.logger = new MockLogger();
    }

    @After
    public void clean() {
        System.clearProperty("anypoint.platform.poll_policies_enabled");
        System.clearProperty("anypoint.platform.api_keep_alive_enabled");
        System.clearProperty("anypoint.platform.poll_clients_enabled");
        System.clearProperty(CLIENT_ID);
        System.clearProperty(CLIENT_SECRET);
    }

    @Test
    public void trackingSuccessfulSpoolSchedulers() {
        this.mockGetApiToReturn200();
        this.executeOnClientConnected();
        ((BackoffSchedulerFactory)Mockito.verify((Object)this.schedulerFactory, (VerificationMode)Mockito.times((int)3))).create((ScheduledExecutorService)org.mockito.Matchers.any(ScheduledExecutorService.class));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.runnableRetrier});
    }

    @Test
    public void policyPollersNotScheduled() {
        this.mockGetApiToReturn200();
        System.setProperty("anypoint.platform.poll_policies_enabled", "false");
        this.executeOnClientConnected();
        this.assertPollersCreated(CONTRACT_POLL_NAME, KEEP_ALIVE_POLL_NAME);
    }

    @Test
    public void keepAliveNotScheduled() {
        this.mockGetApiToReturn200();
        System.setProperty("anypoint.platform.api_keep_alive_enabled", "false");
        this.executeOnClientConnected();
        this.assertPollersCreated(CONTRACT_POLL_NAME, POLICY_POLL_NAME);
    }

    @Test
    public void clientsNotScheduled() {
        this.mockGetApiToReturn200();
        System.setProperty("anypoint.platform.poll_clients_enabled", "false");
        this.executeOnClientConnected();
        this.assertPollersCreated(KEEP_ALIVE_POLL_NAME, POLICY_POLL_NAME);
    }

    @Test
    public void lastTrackingFailsButPollersAreSpooled() {
        this.mockGetApiToFailLast();
        this.executeOnClientConnected();
        ((BackoffSchedulerFactory)Mockito.verify((Object)this.schedulerFactory, (VerificationMode)Mockito.times((int)3))).create((ScheduledExecutorService)org.mockito.Matchers.any(ScheduledExecutorService.class));
        ((RunnableRetrier)Mockito.verify((Object)this.runnableRetrier)).scheduleRetry(org.mockito.Matchers.eq((Object)this.api3.getKey()), (Runnable)org.mockito.Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.runnableRetrier});
    }

    @Test
    public void someTrackerInTheMiddleFails() {
        this.mockGetApiToFailInTheMiddle();
        this.executeOnClientConnected();
        ((BackoffSchedulerFactory)Mockito.verify((Object)this.schedulerFactory, (VerificationMode)Mockito.times((int)3))).create((ScheduledExecutorService)org.mockito.Matchers.any(ScheduledExecutorService.class));
        ((RunnableRetrier)Mockito.verify((Object)this.runnableRetrier)).scheduleRetry(org.mockito.Matchers.eq((Object)this.api2.getKey()), (Runnable)org.mockito.Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.runnableRetrier});
    }

    @Test
    public void pollersDoNotStartInOfflineMode() {
        this.mockGetApiToReturn200();
        this.executeOnClientOffline();
        this.assertPollersWereNotCreated("anypoint.platform.poll_clients_enabled", KEEP_ALIVE_POLL_NAME, POLICY_POLL_NAME);
    }

    @Test
    public void pollersStartByDefaultInOnlineMode() {
        this.mockGetApiToReturn200();
        this.executeOnClientConnected();
        this.assertPollersWereNotCreated("anypoint.platform.poll_clients_enabled", KEEP_ALIVE_POLL_NAME, POLICY_POLL_NAME);
    }

    private void executeOnClientConnected() {
        System.setProperty(CLIENT_ID, "clientId");
        System.setProperty(CLIENT_SECRET, "clientSecret");
        ApiPlatformClientProvider clientProvider = (ApiPlatformClientProvider)Mockito.mock(ApiPlatformClientProvider.class);
        Mockito.when((Object)clientProvider.getClient()).thenReturn((Object)this.restClient);
        PlatformInteractionServicesLifecycle platformManager = new PlatformInteractionServicesLifecycleFactory().create(this.apiService, this.apiTrackingService, this.policyDeploymentTracker, clientProvider, this.schedulerFactory, this.backoffConfigurationSupplier, this.backoffRunnableRetrierFactory, true);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ApiPlatformClientConnectionListener.class);
        ((ApiPlatformClientProvider)Mockito.verify((Object)clientProvider, (VerificationMode)Mockito.atLeastOnce())).addConnectionListener((ApiPlatformClientConnectionListener)captor.capture());
        captor.getAllValues().forEach(ApiPlatformClientConnectionListener::onClientConnected);
    }

    private void executeOnClientOffline() {
        ApiPlatformClientProvider clientProvider = (ApiPlatformClientProvider)Mockito.mock(ApiPlatformClientProvider.class);
        Mockito.when((Object)clientProvider.getClient()).thenReturn((Object)this.restClient);
        PlatformInteractionServicesLifecycle platformManager = new PlatformInteractionServicesLifecycleFactory().create(this.apiService, this.apiTrackingService, this.policyDeploymentTracker, clientProvider, this.schedulerFactory, this.backoffConfigurationSupplier, this.backoffRunnableRetrierFactory, true);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ApiPlatformClientConnectionListener.class);
        ((ApiPlatformClientProvider)Mockito.verify((Object)clientProvider, (VerificationMode)Mockito.never())).addConnectionListener((ApiPlatformClientConnectionListener)captor.capture());
    }

    private void mockGetApiToFailInTheMiddle() {
        ApiResponse apiResponse = (ApiResponse)Mockito.mock(ApiResponse.class);
        Mockito.when((Object)apiResponse.getTrackingInfo()).thenReturn(Mockito.mock(TrackingInfo.class));
        Mockito.when((Object)this.restClient.getApi((ApiKey)org.mockito.Matchers.any(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)new PlatformResponse((Object)apiResponse, 200)).thenThrow(new Throwable[]{new OutOfMemoryError("throwing some crazy Error, may the gods have mercy on us all.")}).thenReturn((Object)new PlatformResponse((Object)apiResponse, 401));
    }

    private void mockGetApiToFailLast() {
        ApiResponse apiResponse = (ApiResponse)Mockito.mock(ApiResponse.class);
        Mockito.when((Object)apiResponse.getTrackingInfo()).thenReturn(Mockito.mock(TrackingInfo.class));
        Mockito.when((Object)this.restClient.getApi((ApiKey)org.mockito.Matchers.any(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)new PlatformResponse((Object)apiResponse, 200)).thenReturn((Object)new PlatformResponse((Object)apiResponse, 401)).thenThrow(new Throwable[]{new OutOfMemoryError("throwing some crazy Error, may the gods have mercy on us all.")});
    }

    private void mockGetApiToReturn200() {
        ApiResponse apiResponse = (ApiResponse)Mockito.mock(ApiResponse.class);
        Mockito.when((Object)apiResponse.getTrackingInfo()).thenReturn(Mockito.mock(TrackingInfo.class));
        Mockito.when((Object)this.restClient.getApi((ApiKey)org.mockito.Matchers.any(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)new PlatformResponse((Object)apiResponse, 200));
    }

    private Api api(long apiId) {
        ApiKey key = new ApiKey(Long.valueOf(apiId));
        ApiImplementation implementation = (ApiImplementation)Mockito.mock(ApiImplementation.class);
        Mockito.when((Object)implementation.getApiKey()).thenReturn((Object)key);
        return new Api(key, implementation, ApiContractsFactory.create((ApiKey)key, Collections.emptyList()));
    }

    private void assertPollersCreated(String ... pollers) {
        ArgumentCaptor acScheduledExecutorService = ArgumentCaptor.forClass(ScheduledExecutorService.class);
        ((BackoffSchedulerFactory)Mockito.verify((Object)this.schedulerFactory, (VerificationMode)Mockito.times((int)pollers.length))).create((ScheduledExecutorService)acScheduledExecutorService.capture());
        this.assertSchedulers(acScheduledExecutorService.getAllValues(), pollers);
    }

    private void assertPollersWereNotCreated(String ... pollers) {
        ArgumentCaptor acScheduledExecutorService = ArgumentCaptor.forClass(ScheduledExecutorService.class);
        MatcherAssert.assertThat((Object)acScheduledExecutorService.getAllValues(), (Matcher)Matchers.not((Matcher)IsIterableContainingInOrder.contains((Object[])pollers)));
    }

    private void assertSchedulers(List<ScheduledExecutorService> allValues, String ... schedulers) {
        List<String> list = Arrays.asList(schedulers);
        list.sort(Comparator.comparing(String::toString));
        List names = allValues.stream().map(scheduledExecutorService -> (String)new Inspector(scheduledExecutorService).read("threadFactory.name")).sorted(Comparator.comparing(String::toString)).collect(Collectors.toList());
        MatcherAssert.assertThat(names, (Matcher)IsIterableContainingInOrder.contains((Object[])list.toArray()));
    }
}

