/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.backoff.mocks;

import com.mulesoft.anypoint.backoff.engine.BackoffSimulation;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiClientsResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.KeepAliveDto;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class SimulatedApiPlatformSession
implements ApiPlatformSession {
    private final int iteration;
    private final BackoffSimulation simulation;
    private SessionMetadata metadata;

    public SimulatedApiPlatformSession(int iteration, BackoffSimulation simulation) {
        this.iteration = iteration;
        this.simulation = simulation;
        this.metadata = this.emptyMetadata();
    }

    public SessionMetadata metadata() {
        return this.metadata;
    }

    public ApiPlatformSession activateEndpoint(String organizationId, String environmentId, Long apiId, KeepAliveDto payload, String etag) {
        this.updateMetadataWithSimulation();
        return this;
    }

    public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId) {
        return this.getApiClients(organizationId, environmentId, apiId, null);
    }

    public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId, String contractsEntityTag) {
        this.updateMetadataWithSimulation();
        return new ApiClientsResponseBuilder().withClients(new ArrayList()).build();
    }

    public ApiResponse getApi(Api api) {
        this.updateMetadataWithSimulation();
        return (ApiResponse)Mockito.mock(ApiResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    public ApiResponse getApi(ApiKey apiKey) {
        Assert.fail((String)"This method should not have been called");
        return null;
    }

    public ApiResponse getApi(ApiKey apiKey, String apiEntityTag) {
        Assert.fail((String)"This method should not have been called");
        return null;
    }

    private void updateMetadataWithSimulation() {
        this.metadata = new SessionMetadata(){

            public int requests() {
                return 1;
            }

            public List<Integer> statusCodes() {
                return Arrays.asList(SimulatedApiPlatformSession.this.simulation.statusCode(SimulatedApiPlatformSession.this.iteration, 200));
            }

            public int getCount(int statusCode) {
                return this.statusCodes().stream().filter(i -> i.equals(statusCode)).collect(Collectors.toList()).size();
            }
        };
    }

    private SessionMetadata emptyMetadata() {
        return new SessionMetadata(){

            public int requests() {
                return 0;
            }

            public List<Integer> statusCodes() {
                return new ArrayList<Integer>();
            }

            public int getCount(int statusCode) {
                return 0;
            }
        };
    }
}

