/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.mocks;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.GateKeeperStatusDto;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.KeepAliveDto;
import com.mulesoft.mule.runtime.gw.client.dto.keepalive.PolicyStatusDto;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.PlatformClientsRetriever;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.KeepAlivePayloadFactory;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ApiKeepAliveRunnable;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ApisRunnable;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ClientsRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;

public class ApiPlatformMocks {
    public static final String ORG_ID = "orgId";
    public static final String ENV_ID = "envId";
    public static final KeepAliveDto KEEP_ALIVE_PAYLOAD = new KeepAliveDto(new GateKeeperStatusDto(false, "DISABLED"), Collections.singletonList(new PolicyStatusDto("1", true, "version", "currentVersion", "DEPLOYMENT_SUCCESS")), null);
    public static final String KEEP_ALIVE_TAG = KEEP_ALIVE_PAYLOAD.eTag();
    public static final String NO_KEEP_ALIVE_TAG = null;
    private final ApiPlatformSession platformSession;
    private final ApiService apiService;
    private final ApiPlatformSessionFactory platformSessionFactory;
    private final BackoffBarrier backoffBarrier;
    private final BackoffConfiguration backoffConfiguration;
    private final KeepAlivePayloadFactory keepAlivePayloadFactory;
    private Api api;
    private Api secondApi;
    private ApiTrackingService apiTrackingService = (ApiTrackingService)Mockito.mock(ApiTrackingService.class);

    public ApiPlatformMocks() {
        this.apiService = (ApiService)Mockito.mock(ApiService.class);
        this.api = (Api)Mockito.mock(Api.class);
        Mockito.when((Object)this.api.getContracts()).thenReturn(Mockito.mock(ApiContracts.class));
        this.secondApi = (Api)Mockito.mock(Api.class);
        this.platformSessionFactory = (ApiPlatformSessionFactory)Mockito.mock(ApiPlatformSessionFactory.class);
        this.platformSession = (ApiPlatformSession)Mockito.mock(ApiPlatformSession.class);
        this.keepAlivePayloadFactory = (KeepAlivePayloadFactory)Mockito.mock(KeepAlivePayloadFactory.class);
        Mockito.when((Object)this.platformSessionFactory.create()).thenReturn((Object)this.platformSession);
        Mockito.when((Object)this.platformSession.metadata()).thenReturn((Object)this.emptySessionMetadata());
        this.backoffBarrier = (sessionMetadata, configuration) -> false;
        this.backoffConfiguration = new BackoffConfiguration.Builder(true).build();
        this.createExpectations();
    }

    private SessionMetadata emptySessionMetadata() {
        return new SessionMetadata(){

            public int requests() {
                return 0;
            }

            public List<Integer> statusCodes() {
                return new ArrayList<Integer>();
            }

            public int getCount(int statusCode) {
                return 0;
            }
        };
    }

    public ClientsRunnable clientsRunnable() {
        return new ClientsRunnable(this.apiTrackingService, this.platformSessionFactory, this.backoffBarrier, this.backoffConfiguration, new PlatformClientsRetriever(this.platformSessionFactory, this.apiTrackingService));
    }

    public ApisRunnable apisRunnable() {
        return new ApisRunnable(this.apiTrackingService, this.platformSessionFactory, this.backoffBarrier, this.backoffConfiguration);
    }

    public ApiKeepAliveRunnable keepAliveRunnable() throws IOException {
        Mockito.when((Object)this.keepAlivePayloadFactory.create((Api)ArgumentMatchers.any())).thenReturn((Object)KEEP_ALIVE_PAYLOAD);
        return new ApiKeepAliveRunnable(this.apiTrackingService, this.platformSessionFactory, this.keepAlivePayloadFactory, this.backoffBarrier, this.backoffConfiguration);
    }

    public ApiPlatformSession session() {
        return this.platformSession;
    }

    public ApiService apiService() {
        return this.apiService;
    }

    public ApiTrackingService apiTrackingService() {
        return this.apiTrackingService;
    }

    public ApiPlatformMocks singleTrackedApi() {
        Mockito.when((Object)this.apiTrackingService.getTrackedApis()).thenReturn((Object)Lists.newArrayList((Object[])new Api[]{this.api()}));
        return this;
    }

    public ApiPlatformMocks multipleTrackedApis() {
        Mockito.when((Object)this.apiTrackingService.getTrackedApis()).thenReturn((Object)Lists.newArrayList((Object[])new Api[]{this.api(), this.secondApi()}));
        return this;
    }

    public ApiPlatformMocks singleApiFetchContracts() {
        this.singleTrackedApi();
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts()).thenReturn((Object)Lists.newArrayList((Object[])new Api[]{this.api()}));
        return this;
    }

    public ApiPlatformMocks multipleApisFetchContracts() {
        this.multipleTrackedApis();
        Mockito.when((Object)this.apiTrackingService.getTrackedApisRequiringContracts()).thenReturn((Object)Lists.newArrayList((Object[])new Api[]{this.api(), this.secondApi()}));
        return this;
    }

    public ApiPlatformMocks stoppedApi() {
        Mockito.when((Object)this.api.getImplementation().getFlow().getMuleContext().isStarted()).thenReturn((Object)false);
        return this;
    }

    public ApiPlatformMocks keepAliveSent() {
        Mockito.when((Object)this.api.getTrackingInfo().getKeepAliveEntityTag()).thenReturn((Object)KEEP_ALIVE_TAG);
        return this;
    }

    public Api api() {
        return this.api;
    }

    public Api secondApi() {
        return this.secondApi;
    }

    public ApiPlatformMocks getApiClientsReturns(Api api, ApiClientsResponse apiClientsResponse) {
        TrackingInfo trackingInfo = api.getTrackingInfo();
        Mockito.when((Object)this.platformSession.getApiClients(trackingInfo.getOrganizationId(), trackingInfo.getEnvironmentId(), trackingInfo.getId(), trackingInfo.getContractsEntityTag())).thenReturn((Object)apiClientsResponse);
        return this;
    }

    public ApiPlatformMocks getApiClientsThrows(Api api, Exception exception) {
        TrackingInfo trackingInfo = api.getTrackingInfo();
        Mockito.when((Object)this.platformSession.getApiClients(trackingInfo.getOrganizationId(), trackingInfo.getEnvironmentId(), trackingInfo.getId(), trackingInfo.getContractsEntityTag())).thenThrow(new Throwable[]{exception});
        return this;
    }

    public ApiPlatformMocks getApiReturns(Api api, ApiResponse apiResponse) {
        Mockito.when((Object)this.platformSession.getApi(api)).thenReturn((Object)apiResponse);
        return this;
    }

    public ApiPlatformMocks getApiThrows(Api api, Exception exception) {
        Mockito.when((Object)this.platformSession.getApi(api)).thenThrow(new Throwable[]{exception});
        return this;
    }

    private void createExpectations() {
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)this.api.getTrackingInfo()).thenReturn(Mockito.mock(TrackingInfo.class));
        Mockito.when((Object)this.api.getTrackingInfo().getId()).thenReturn((Object)PolicyTestValuesConstants.API_KEY.id());
        Mockito.when((Object)this.api.getTrackingInfo().getEnvironmentId()).thenReturn((Object)ENV_ID);
        Mockito.when((Object)this.api.getTrackingInfo().getOrganizationId()).thenReturn((Object)ORG_ID);
        Mockito.when((Object)this.api.getContracts()).thenReturn(Mockito.mock(ApiContracts.class));
        Mockito.when((Object)this.api.getImplementation()).thenReturn(Mockito.mock(ApiImplementation.class));
        Mockito.when((Object)this.api.getImplementation().getFlow()).thenReturn(Mockito.mock(Flow.class));
        Mockito.when((Object)this.api.getImplementation().getFlow().getMuleContext()).thenReturn(Mockito.mock(MuleContext.class));
        Mockito.when((Object)this.api.getImplementation().getFlow().getMuleContext().isStarted()).thenReturn((Object)true);
        Mockito.when((Object)this.secondApi.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY_2);
        Mockito.when((Object)this.secondApi.getTrackingInfo()).thenReturn(Mockito.mock(TrackingInfo.class));
        Mockito.when((Object)this.secondApi.getTrackingInfo().getId()).thenReturn((Object)PolicyTestValuesConstants.API_KEY_2.id());
        Mockito.when((Object)this.secondApi.getTrackingInfo().getEnvironmentId()).thenReturn((Object)ENV_ID);
        Mockito.when((Object)this.secondApi.getTrackingInfo().getOrganizationId()).thenReturn((Object)ORG_ID);
        Mockito.when((Object)this.secondApi.getContracts()).thenReturn(Mockito.mock(ApiContracts.class));
        Mockito.when((Object)this.secondApi.getImplementation()).thenReturn(Mockito.mock(ApiImplementation.class));
        Mockito.when((Object)this.secondApi.getImplementation().getFlow()).thenReturn(Mockito.mock(Flow.class));
        Mockito.when((Object)this.secondApi.getImplementation().getFlow().getMuleContext()).thenReturn(Mockito.mock(MuleContext.class));
        Mockito.when((Object)this.secondApi.getImplementation().getFlow().getMuleContext().isStarted()).thenReturn((Object)true);
    }
}

