/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.pollers;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.function.BoundedExponentialFunction;
import com.mulesoft.anypoint.backoff.function.Round;
import com.mulesoft.anypoint.backoff.function.dispersion.RangeDispersant;
import com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.pollers.GatewayPollersTestCase;
import java.util.Arrays;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class BackoffConfigurationTestCase
extends GatewayPollersTestCase {
    @Test
    public void defaultIfNotConfigured() {
        BackoffConfiguration configuration = this.backoffConfigurationBuilder(true).build();
        MatcherAssert.assertThat((Object)configuration.backoffSteps(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)configuration.backonSteps(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)configuration.failurePercentage(), (Matcher)Matchers.is((Object)100.0));
        MatcherAssert.assertThat((Object)configuration.backoff(), (Matcher)Matchers.is((Object)this.defaultBackoffFunction()));
        MatcherAssert.assertThat((Object)configuration.backon(), (Matcher)Matchers.is((Object)this.defaultBackonFunction()));
        MatcherAssert.assertThat((Object)configuration.statusCodes(), (Matcher)Matchers.is((Object)PlatformClientConfiguration.DEFAULT_OUTAGE_STATUS_CODES));
    }

    @Test
    public void configureFailurePercentage() {
        BackoffConfiguration configuration = this.backoffConfigurationBuilder(true).failurePercentage(50.0).build();
        MatcherAssert.assertThat((Object)configuration.failurePercentage(), (Matcher)Matchers.is((Object)50.0));
    }

    @Test
    public void configureStatusCodes() {
        Integer[] statusCodes = new Integer[]{200, 322, 666};
        BackoffConfiguration configuration = this.backoffConfigurationBuilder(true).statusCodes(statusCodes).build();
        MatcherAssert.assertThat((Object)configuration.statusCodes(), (Matcher)Matchers.is(Arrays.asList(statusCodes)));
    }

    @Test
    public void configureBackoff() {
        BackoffConfiguration configuration = this.backoffConfigurationBuilder(true).backoff(2.0, 1.5, 0.33, 15).build();
        MatcherAssert.assertThat((Object)configuration.backoffSteps(), (Matcher)Matchers.is((Object)15));
        MatcherAssert.assertThat((Object)configuration.backoff(), (Matcher)Matchers.is((Object)new Round((Function)new BoundedExponentialFunction(2.0, 0, 15, 1.5, (Function)new RangeDispersant(0.33, 1.0)))));
        MatcherAssert.assertThat((Object)configuration.backon(), (Matcher)Matchers.is((Object)this.defaultBackonFunction()));
    }

    @Test
    public void configureBackon() {
        BackoffConfiguration configuration = this.backoffConfigurationBuilder(true).backon(2.0, 1.5, 0.33, 15).build();
        MatcherAssert.assertThat((Object)configuration.backonSteps(), (Matcher)Matchers.is((Object)15));
        MatcherAssert.assertThat((Object)configuration.backon(), (Matcher)Matchers.is((Object)new Round((Function)new BoundedExponentialFunction(2.0, 0, 15, 1.5, (Function)new RangeDispersant(0.33, 1.0)))));
        MatcherAssert.assertThat((Object)configuration.backoff(), (Matcher)Matchers.is((Object)this.defaultBackoffFunction()));
    }

    @Test
    public void configurationCanBeDisabled() {
        BackoffConfiguration configuration = this.backoffConfigurationBuilder(false).build();
        MatcherAssert.assertThat((Object)configuration.statusCodes(), (Matcher)Matchers.hasSize((int)0));
    }

    private BackoffConfiguration.Builder backoffConfigurationBuilder(boolean backoff) {
        return new BackoffConfiguration.Builder(backoff);
    }
}

