/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedApiConfigurationCache;
import com.mulesoft.mule.runtime.gw.deployment.replication.DistributedApiConfigurationEntry;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterRuntimeException;
import com.mulesoft.mule.runtime.module.cluster.api.map.ClusterMap;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DistributedApiConfigurationCacheTestCase
extends AbstractMuleTestCase {
    private static final String API_KEY_AS_STRING = PolicyTestValuesConstants.API_KEY.id().toString();
    private ContractRepository contractRepository;
    private DistributedApiConfigurationCache apiConfigurationCache;
    private ClusterMap clusterMap;
    private HazelcastClusterManager hazelcastManager;
    private PolicySetDeploymentService policySetDeploymentService;

    @Before
    public void setUp() {
        this.contractRepository = (ContractRepository)Mockito.mock(ContractRepository.class);
        this.clusterMap = (ClusterMap)Mockito.mock(ClusterMap.class);
        this.hazelcastManager = (HazelcastClusterManager)Mockito.mock(HazelcastClusterManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.policySetDeploymentService = (PolicySetDeploymentService)Mockito.mock(PolicySetDeploymentService.class);
        ApiService apiService = (ApiService)Mockito.mock(ApiService.class);
        ContractSnapshots contractSnapshots = (ContractSnapshots)Mockito.mock(ContractSnapshots.class);
        Mockito.when((Object)this.hazelcastManager.getMap(org.mockito.Matchers.anyString())).thenReturn((Object)this.clusterMap);
        this.apiConfigurationCache = new DistributedApiConfigurationCache(apiService, this.policySetDeploymentService, contractSnapshots, this.hazelcastManager);
        VariableOverride.overrideVariable((String)"contractRepository").in((Object)this.apiConfigurationCache).with((Object)this.contractRepository);
    }

    @Test
    public void getPolicySet() throws InitialisationException {
        PolicyDefinition policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class);
        DistributedApiConfigurationEntry entry = new DistributedApiConfigurationEntry(new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{policyDefinition}), PolicySet.PolicySetOrigin.FILE_SYSTEM), Collections.emptyList());
        Mockito.when((Object)this.clusterMap.get((Object)API_KEY_AS_STRING)).thenReturn((Object)entry);
        Mockito.when((Object)this.clusterMap.containsKey((Object)API_KEY_AS_STRING)).thenReturn((Object)true);
        Optional policySet = this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)policySet.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PolicySet)policySet.get()).isFromPlatform(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((PolicySet)policySet.get()).getPolicyDefinitions(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((PolicySet)policySet.get()).getPolicyDefinitions(), (Matcher)Matchers.hasItems((Object[])new PolicyDefinition[]{policyDefinition}));
    }

    @Test
    public void getEmptySet() throws InitialisationException {
        Mockito.when((Object)this.clusterMap.containsKey((Object)PolicyTestValuesConstants.API_KEY)).thenReturn((Object)false);
        Mockito.when((Object)this.contractRepository.containsSla(PolicyTestValuesConstants.API_KEY)).thenReturn((Object)true);
        Optional policySet = this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)policySet.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((PolicySet)policySet.get()).isFromPlatform(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((PolicySet)policySet.get()).getPolicyDefinitions(), (Matcher)Matchers.empty());
    }

    @Test
    public void getEmpty() throws InitialisationException {
        Mockito.when((Object)this.clusterMap.containsKey((Object)PolicyTestValuesConstants.API_KEY)).thenReturn((Object)false);
        Mockito.when((Object)this.contractRepository.containsSla(PolicyTestValuesConstants.API_KEY)).thenReturn((Object)false);
        Optional policySet = this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((Object)policySet.isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void remove() {
        this.apiConfigurationCache.remove(PolicyTestValuesConstants.API_KEY);
        ((ClusterMap)Mockito.verify((Object)this.clusterMap)).remove((Object)API_KEY_AS_STRING);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.clusterMap});
        ((HazelcastClusterManager)Mockito.verify((Object)this.hazelcastManager, (VerificationMode)Mockito.times((int)1))).getMap(org.mockito.Matchers.anyString());
        ((HazelcastClusterManager)Mockito.verify((Object)this.hazelcastManager, (VerificationMode)Mockito.times((int)1))).getClusterId();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hazelcastManager});
    }

    @Test
    public void initializeIncompatible() {
        HashMap<ApiKey, List<Object>> map = new HashMap<ApiKey, List<Object>>();
        map.put(PolicyTestValuesConstants.API_KEY, Collections.singletonList(Mockito.mock(PolicyDefinition.class)));
        Mockito.when((Object)this.policySetDeploymentService.storedOnlinePoliciesByApi()).thenReturn(map);
        Mockito.when((Object)this.clusterMap.get((Object)API_KEY_AS_STRING)).thenThrow(new Throwable[]{new ClusterRuntimeException("")});
        this.apiConfigurationCache.initialise((ApiTrackingService)Mockito.mock(ApiTrackingService.class));
        ((ClusterMap)Mockito.verify((Object)this.clusterMap)).get((Object)API_KEY_AS_STRING);
    }

    @Test
    public void getIncompatible() {
        Mockito.when((Object)this.clusterMap.containsKey((Object)API_KEY_AS_STRING)).thenReturn((Object)true);
        Mockito.when((Object)this.clusterMap.get((Object)API_KEY_AS_STRING)).thenThrow(new Throwable[]{new ClusterRuntimeException("")});
        Optional policySet = this.apiConfigurationCache.getPolicies(PolicyTestValuesConstants.API_KEY);
        ((ClusterMap)Mockito.verify((Object)this.clusterMap)).get((Object)API_KEY_AS_STRING);
    }

    @Test
    public void storeIncompatible() {
        PolicyDefinition policyDefinition = (PolicyDefinition)Mockito.mock(PolicyDefinition.class);
        PolicySet set = new PolicySet((List)Lists.newArrayList((Object[])new PolicyDefinition[]{policyDefinition}), PolicySet.PolicySetOrigin.FILE_SYSTEM);
        Mockito.when((Object)this.clusterMap.put(ArgumentMatchers.eq((Object)API_KEY_AS_STRING), ArgumentMatchers.any())).thenThrow(new Throwable[]{new ClusterRuntimeException("")});
        this.apiConfigurationCache.set(PolicyTestValuesConstants.API_KEY, set, Collections.emptyList());
        ((ClusterMap)Mockito.verify((Object)this.clusterMap)).put(ArgumentMatchers.eq((Object)API_KEY_AS_STRING), ArgumentMatchers.any());
    }
}

