/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.service;

import com.mulesoft.mule.runtime.gw.api.client.ClientsRepository;
import com.mulesoft.mule.runtime.gw.api.client.ClientsRepositoryException;
import com.mulesoft.mule.runtime.gw.api.client.CoreServicesClient;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.dto.CoreServicesClientDto;
import com.mulesoft.mule.runtime.gw.client.dto.LegacyCoreServicesClientDto;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.response.PlatformResponse;
import java.util.Objects;
import org.mule.runtime.core.internal.util.OneTimeWarning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreServicesClientsRepository
implements ClientsRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreServicesClientsRepository.class);
    private ApiPlatformClient platform;
    private boolean legacyEnabled;
    private OneTimeWarning legacyDisabledLog = new OneTimeWarning(LOGGER, "Oauth2 Legacy endpoint disabled. Make sure to update your client store and Oauth2 provider modules. All Oauth2 token generations will fail.");
    private OneTimeWarning newEndpointMissing = new OneTimeWarning(LOGGER, "Could not find the new client application endpoint, defaulting to legacy endpoint.");

    public CoreServicesClientsRepository(ApiPlatformClient platform, boolean legacyEnabled) {
        this.legacyEnabled = legacyEnabled;
        Objects.requireNonNull(platform, String.format("%s is null, cannot create the %s", ApiPlatformClient.class.getSimpleName(), CoreServicesClientsRepository.class.getSimpleName()));
        this.platform = platform;
    }

    public CoreServicesClient getBy(String id) throws ClientsRepositoryException {
        this.legacyCheck(id);
        try {
            PlatformResponse platformResponse = this.platform.getClient(id);
            if (platformResponse.statusCode() >= 400) {
                throw new ClientsRepositoryException(this.exceptionMessage(id), platformResponse.statusCode());
            }
            LegacyCoreServicesClientDto dto = (LegacyCoreServicesClientDto)platformResponse.entity();
            return CoreServicesClient.getBuilder().withId(dto.getId()).withSecret(dto.getSecret()).withName(dto.getName()).withRedirectionUris(dto.getRedirectUris()).build();
        }
        catch (ClientsRepositoryException e) {
            throw e;
        }
        catch (HttpConnectionException e) {
            LOGGER.error("There was a connection error while looking for client with id '{}'. Cause: {}.", (Object)id, (Object)e.getMessage());
            throw new ClientsRepositoryException(this.exceptionMessage(id), e.statusCode());
        }
        catch (HttpResponseException e) {
            LOGGER.error("Invalid status code returned, {}, when looking for client with id '{}'.", (Object)e.statusCode(), (Object)id);
            throw new ClientsRepositoryException(this.exceptionMessage(id), e.statusCode());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error, when looking for client with id '{}'.", (Object)id, (Object)e);
            throw new ClientsRepositoryException(this.exceptionMessage(id), 500);
        }
    }

    public CoreServicesClient getBy(String id, String secret) throws ClientsRepositoryException {
        try {
            PlatformResponse platformResponse = this.platform.getClient(id, secret);
            CoreServicesClientDto dto = this.unwrap((PlatformResponse<CoreServicesClientDto>)platformResponse);
            if (!dto.getValidated()) {
                throw new ClientsRepositoryException(this.exceptionMessage(id), platformResponse.statusCode());
            }
            return CoreServicesClient.getBuilder().withId(dto.getId()).withSecret(secret).withName(dto.getName()).withRedirectionUris(dto.getRedirectUris()).build();
        }
        catch (ClientsRepositoryException e) {
            throw e;
        }
        catch (HttpResponseException e) {
            if (e.statusCode() == 404) {
                this.newEndpointMissing.warn();
                return this.getBy(id);
            }
            LOGGER.error("Invalid status code returned, {}, when looking for client with id '{}'.", new Object[]{e.statusCode(), id, e});
            throw new ClientsRepositoryException(this.exceptionMessage(id), e.statusCode());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error, when looking for client with id '{}'.", (Object)id, (Object)e);
            throw new ClientsRepositoryException(this.exceptionMessage(id), 500);
        }
    }

    private CoreServicesClientDto unwrap(PlatformResponse<CoreServicesClientDto> platformResponse) {
        if (platformResponse.statusCode() != 200) {
            throw new HttpResponseException("Platform returned unexpected status code.", platformResponse.statusCode());
        }
        return (CoreServicesClientDto)platformResponse.entity();
    }

    private String exceptionMessage(String id) {
        return String.format("Invalid client with id '%s'.", id);
    }

    private void legacyCheck(String id) throws ClientsRepositoryException {
        if (!this.legacyEnabled) {
            this.legacyDisabledLog.warn();
            throw new ClientsRepositoryException(this.exceptionMessage(id), 400);
        }
    }
}

