/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.service;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.agent.HealthCheck;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.autodiscovery.ApiDiscovery;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.notification.ApiNotificationManager;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.contracts.ApiContractsFactory;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRegistry;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.DefaultHealthCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.slf4j.Logger;

public class DefaultApiService
implements ApiService,
DeploymentListener {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiService.class);
    private final ApiDiscovery apiDiscovery;
    private final DeploymentService deploymentService;
    private final ApiNotificationManager apiNotificationManager;
    private final Map<ApiKey, Api> apis = Collections.synchronizedMap(new WeakHashMap());
    private final HealthCheck healthCheck;
    private final Object deployLock;
    private List<ApiContractsListener> apiContractsListeners = new LinkedList<ApiContractsListener>();

    public DefaultApiService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        this.apiDiscovery = new ApiDiscovery();
        this.apiNotificationManager = new ApiNotificationManager();
        this.healthCheck = new DefaultHealthCheck((ApiService)this);
        this.deployLock = new Object();
    }

    public void onArtifactInitialised(String artifactName, Registry registry) {
        Application application = this.deploymentService.findApplication(artifactName);
        this.apiDiscovery.autoDiscoveryMetadatas(registry).forEach(apiMetadata -> {
            ApiKey apiKey = apiMetadata.getApiKey();
            Object object = this.deployLock;
            synchronized (object) {
                if (!this.apis.containsKey(apiKey)) {
                    ApiImplementation implementation = new ApiImplementation(apiKey, application, apiMetadata.getFlow(), apiMetadata.isIgnoreBasePath());
                    this.deployApi(artifactName, apiKey, implementation);
                } else {
                    LOGGER.warn("API {} is already deployed on app {}. This API deployment won't be tracked.", (Object)apiMetadata.getApiKey(), (Object)this.apis.get(apiKey).getImplementation().getArtifactName());
                }
            }
        });
    }

    private Api deployApi(String artifactName, ApiKey apiKey, ApiImplementation implementation) {
        LOGGER.debug("New API deployment {}, on app {}", (Object)apiKey, (Object)artifactName);
        Api api = new Api(apiKey, implementation, ApiContractsFactory.create((ApiKey)apiKey, this.apiContractsListeners));
        this.apis.put(implementation.getApiKey(), api);
        api.initialise();
        this.apiNotificationManager.notifyApiDeploymentStart(api);
        return api;
    }

    public void addApiContractsListener(ApiContractsListener apiContractsListener) {
        this.apiContractsListeners.add(apiContractsListener);
    }

    public void onDeploymentSuccess(String artifactName) {
        this.findApiByArtifactName(artifactName).forEach(this.apiNotificationManager::notifyApiDeploymentSuccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeploymentFailure(String artifactName, Throwable cause) {
        Map<ApiKey, Api> map = this.apis;
        synchronized (map) {
            this.findApiByArtifactName(artifactName).forEach(api -> this.apis.remove(api.getKey()));
        }
    }

    public void onUndeploymentStart(String artifactName) {
        this.undeployApplicationApis(artifactName, api -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployApplicationApis(String artifactName, Predicate<Api> filter) {
        Object object = this.deployLock;
        synchronized (object) {
            this.findApiByArtifactName(artifactName).stream().filter(filter).forEach(api -> {
                LOGGER.debug("API {} un-deployment started", api);
                this.apiNotificationManager.notifyApiUndeploymentStart(api.getImplementation());
                api.dispose();
                this.apis.remove(api.getKey());
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRedeploymentStart(String artifactName) {
        Object object = this.deployLock;
        synchronized (object) {
            List<Api> redeployedApis = this.findApiByArtifactName(artifactName);
            redeployedApis.forEach(api -> {
                LOGGER.debug("API {} re-deployment started", api);
                this.apiNotificationManager.notifyApiRedeploymentStart(api.getImplementation());
                this.apis.remove(api.getKey());
            });
        }
    }

    public boolean isDeployed(ApiKey apiKey) {
        return this.apis.containsKey(apiKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ApiImplementation> getImplementation(ApiKey apiKey) {
        Map<ApiKey, Api> map = this.apis;
        synchronized (map) {
            return this.apis.containsKey(apiKey) ? Optional.ofNullable(this.apis.get(apiKey).getImplementation()) : Optional.empty();
        }
    }

    public Optional<Api> get(ApiKey apiKey) {
        return Optional.ofNullable(this.apis.get(apiKey));
    }

    public Optional<Api> find(String appName, String flowName) {
        return this.apis.values().stream().filter(internalApi -> flowName.equals(internalApi.getImplementation().getFlow().getName()) && appName.equals(internalApi.getImplementation().getArtifactName())).findFirst();
    }

    public Optional<Api> find(String appName, String flowName, Supplier<String> serviceSupplier) {
        Optional<Api> api = this.find(appName, flowName);
        if (api.isPresent() && api.get().isOffline()) {
            return this.findHdpApi(appName, flowName, serviceSupplier.get());
        }
        return api;
    }

    private Optional<Api> findHdpApi(String appName, String flowName, String service) {
        if (service == null) {
            return Optional.empty();
        }
        return this.apis.values().stream().filter(api -> flowName.equals(api.getImplementation().getFlow().getName()) && appName.equals(api.getImplementation().getArtifactName()) && service.equals(api.getImplementation().getHdpService().orElse(null))).findFirst();
    }

    public List<Api> getApis() {
        return new ArrayList<Api>(this.apis.values());
    }

    public void addDeploymentListener(ApiDeploymentListener apiDeploymentListener) {
        this.apiNotificationManager.addApiDeploymentListener(apiDeploymentListener);
    }

    public void removeDeploymentListener(ApiDeploymentListener apiDeploymentListener) {
        this.apiNotificationManager.removeApiDeploymentListener(apiDeploymentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHdpApis(ApiRegistry apiRegistry) {
        String appName = apiRegistry.getApplicationName();
        Application application = this.deploymentService.findApplication(appName);
        Object object = this.deployLock;
        synchronized (object) {
            this.undeployApplicationApis(appName, api -> !apiRegistry.containsApi(api) && !api.isOffline());
            apiRegistry.getApiRecords().forEach(t -> {
                if (!this.apis.containsKey(t.getApiKey())) {
                    LOGGER.debug("New API deployment {}, on high density proxy {}. API blocked", t, (Object)appName);
                    ApiImplementation implementation = new ApiImplementation(t.getApiKey(), application, this.getHdpFlow(application), t.getServiceName(), true);
                    Api api = this.deployApi(appName, t.getApiKey(), implementation);
                    application.getRegistry().lookupByName("hdp-apis-healthcheck").ifPresent(apisHealthCheck -> ((Map)apisHealthCheck).put(String.format("hdp-hc-%s-%s", appName, implementation.getApiKey().id().toString()), this.healthCheck.getApiValidator(implementation.getApiKey().id())));
                    this.apiNotificationManager.notifyApiDeploymentSuccess(api);
                } else if (!appName.equals(this.apis.get(t.getApiKey()).getImplementation().getArtifactName())) {
                    LOGGER.error("API {} is already deployed on app {}. This API deployment won't be tracked.", (Object)t.getApiKey(), (Object)this.apis.get(t.getApiKey()).getImplementation().getArtifactName());
                }
            });
        }
    }

    private Flow getHdpFlow(Application application) {
        Optional hdpFlow = application.getRegistry().lookupByType(Flow.class);
        return (Flow)hdpFlow.orElseThrow(() -> new RuntimeException("HDP application has no flows"));
    }

    public Optional<ApiContracts> getContracts(ApiKey key) {
        return this.get(key).map(Api::getContracts);
    }

    public DefaultApiService contractsRequired(ApiKey key) {
        this.get(key).ifPresent(api -> this.apiContractsListeners.forEach(listener -> listener.onContractsRequired(api)));
        return this;
    }

    public DefaultApiService noContractsRequired(ApiKey key) {
        this.get(key).ifPresent(api -> this.apiContractsListeners.forEach(listener -> listener.onNoContractsRequired(api)));
        return this;
    }

    private List<Api> findApiByArtifactName(String artifactName) {
        return this.getApis().stream().filter(api -> artifactName.equals(api.getImplementation().getArtifactName())).collect(Collectors.toList());
    }
}

