/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.replication;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.model.PolicySet;

import java.util.List;
import java.util.Optional;

/**
 * This acts as a mirror of Platform data, related to what policies and SLAs an API has configured
 */
public interface ApiConfigurationCache {

  /**
   * Creates or updates a record of the set of policies of an API
   * 
   * @param policySet policy set of the specified API
   * @param slas SLAs of the specified API
   */
  void set(ApiKey apiKey, PolicySet policySet, List<Sla> slas);

  /**
   * Removes a record of the set of policies of an API
   * 
   * @param apiKey API's key.
   */
  void remove(ApiKey apiKey);

  /**
   * Retrieves the set of policies of an API
   *
   * @param apiKey the API
   * @return the set or empty if there is no record
   */
  Optional<PolicySet> getPolicies(ApiKey apiKey);

  /**
   * Initialises the {@link ApiConfigurationCache} with an {@link ApiTrackingService}. Both object depend on each other, so this
   * parameter cannot be set in the constructor.
   * 
   * @param apiTrackingService current {@link ApiTrackingService}.
   */
  void initialise(ApiTrackingService apiTrackingService);
}

