/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;

import java.util.List;

public interface ApiTrackingService {

  /**
   * Indicates that an API was successfully tracked against API Platform
   * 
   * @param apiKey the key of the API
   * @param trackingInfo the tracking information containing API data
   * @param policySet the policy set present in the response of the polling process
   * @param slas the collection of tiers present in the response of the polling process
   */
  void apiTracked(ApiKey apiKey, TrackingInfo trackingInfo, PolicySet policySet, List<Sla> slas);

  /**
   * Indicates that an API does not exist in API Platform
   *
   * @param apiKey the key of the API deployed in the runtime
   */
  void apiUntracked(ApiKey apiKey);

  /**
   * Indicates that there was an error while trying to track an API against API Platform
   *
   * @param apiKey the key of the API
   */
  void apiTrackingFailed(ApiKey apiKey);

  /**
   * Returns the deployed APIs in this runtime that were successfully tracked
   *
   * @return the list of deployed APIs or empty if there are none
   */
  List<Api> getTrackedApis();

  /**
   * Returns the deployed APIs in this runtime that are not still tracked because there was a previous error while doing it. APIs
   * that are deployed but do not exist in API Platform are not returned.
   * 
   * @return the list of apis
   */
  List<Api> getFailedTrackingApis();

  /**
   * Returns the deployed APIs in this runtime that were successfully tracked and requires {@link Contract}s to be fetched
   *
   * @return the list of deployed APIs with {@link Contract}s or empty if there are none
   */
  List<Api> getTrackedApisRequiringContracts();

  /**
   * Indicates that a successful polling of API's clients happened
   *
   * @param apiKey the key of the API
   * @param contracts the new polled contracts
   * @param contractsEntityTag, eTag provided by the platform when retrieving API Clients. This is updated in the API
   *        {@link TrackingInfo}
   */
  void clientsPolling(ApiKey apiKey, List<PlatformContractAdapter> contracts, String contractsEntityTag);

}
