/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction;

import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.ApisPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.ClientsPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.KeepAlivePlatformInteractionLifecycle;

public class PlatformInteractionServicesLifecycle implements PlatformInteractionLifecycle, PrimaryNodeListener {

  private final ApisPlatformInteractionLifecycle apisPlatformInteractionLifecycle;
  private final KeepAlivePlatformInteractionLifecycle keepAlivePlatformInteractionLifecycle;
  private final ClientsPlatformInteractionLifecycle clientsPlatformInteractionLifecycle;

  public PlatformInteractionServicesLifecycle(ApisPlatformInteractionLifecycle apisPlatformInteractionLifecycle,
                                              KeepAlivePlatformInteractionLifecycle keepAlivePlatformInteractionLifecycle,
                                              ClientsPlatformInteractionLifecycle clientsPlatformInteractionLifecycle) {
    this.clientsPlatformInteractionLifecycle = clientsPlatformInteractionLifecycle;
    this.keepAlivePlatformInteractionLifecycle = keepAlivePlatformInteractionLifecycle;
    this.apisPlatformInteractionLifecycle = apisPlatformInteractionLifecycle;
  }

  @Override
  public void primaryNode() {
    apisPlatformInteractionLifecycle.primaryNode();
    keepAlivePlatformInteractionLifecycle.primaryNode();
  }

  @Override
  public void dispose() {
    this.apisPlatformInteractionLifecycle.dispose();
    this.keepAlivePlatformInteractionLifecycle.dispose();
    this.clientsPlatformInteractionLifecycle.dispose();
  }
}
