/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction;

import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;

import java.util.concurrent.atomic.AtomicBoolean;

public class PrimaryPollerPlatformInteractionLifecycle implements PrimaryNodeListener, PlatformInteractionLifecycle,
    ApiPlatformClientConnectionListener {

  private PollerPlatformInteractionLifecycle pollerLifecycle;
  private boolean standaloneOrPrimaryNode;
  private final AtomicBoolean connected = new AtomicBoolean(false);

  public PrimaryPollerPlatformInteractionLifecycle(PollerPlatformInteractionLifecycle pollerLifecycle,
                                                   boolean standaloneOrPrimaryNode) {
    this.pollerLifecycle = pollerLifecycle;
    this.standaloneOrPrimaryNode = standaloneOrPrimaryNode;
  }

  @Override
  public void onClientConnected() {
    synchronized (connected) {
      if (standaloneOrPrimaryNode) {
        pollerLifecycle.onClientConnected();
      }
      connected.set(true);
    }
  }

  @Override
  public void primaryNode() {
    synchronized (connected) {
      standaloneOrPrimaryNode = true;
      if (connected.get()) {
        pollerLifecycle.onClientConnected();
      }
    }
  }

  @Override
  public void dispose() {
    pollerLifecycle.dispose();
  }
}
