/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PrimaryPollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;

public class KeepAlivePlatformInteractionLifecycleFactory {

  public KeepAlivePlatformInteractionLifecycle create(GatewayConfiguration configuration, boolean standaloneOrPrimary,
                                                      ApiTrackingService apiTrackingService,
                                                      ApiPlatformClientProvider clientProvider,
                                                      ApiPlatformSessionFactory restPlatformSessionFactory,
                                                      BackoffSchedulerFactory schedulerFactory,
                                                      BackoffConfigurationSupplier backoffConfigurationSupplier) {

    if (configuration.platformServices().getApiKeepAliveEnabled()) {
      GatewayKeepAlivePoller pollerManager =
          new GatewayKeepAlivePoller(configuration, apiTrackingService, restPlatformSessionFactory,
                                     schedulerFactory, backoffConfigurationSupplier);

      PollerPlatformInteractionLifecycle pollerLifecycle = new PollerPlatformInteractionLifecycle(pollerManager);


      KeepAlivePlatformInteractionLifecycleAdapter lifecycle = new KeepAlivePlatformInteractionLifecycleAdapter(
                                                                                                                new PrimaryPollerPlatformInteractionLifecycle(pollerLifecycle,
                                                                                                                                                              standaloneOrPrimary));

      clientProvider.addConnectionListener(lifecycle);

      return lifecycle;
    }

    return new DisabledKeepAlivePlatformInteractionLifecycle();
  }
}
