/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import static java.util.Arrays.asList;

import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.deployment.mocks.ApiPlatformMocks;

import java.util.HashSet;

import org.junit.Before;

public abstract class ApiPlatformTestCase extends AbstractMuleTestCase {

  protected static final int SLA_ID = 1;
  protected static final int ANOTHER_SLA_ID = 1902;

  protected ApiPlatformMocks mocks;

  @Before
  public void setUp() throws Exception {
    mocks = new ApiPlatformMocks();
  }

  protected ApiClientDto dtoClient(int id, Long apiId, String slaId) {
    return new ApiClientDto("clientId" + id,
                            "clientSecret" + id,
                            "clientName" + id,
                            "masterOrg" + id,
                            slaId,
                            apiId.toString(),
                            Integer.toString(0), // Contract is an irrelevant property,
                            new HashSet<>());
  }

  protected Sla sla(int slaId) {
    return singleLimitSla(slaId);
  }

  protected Sla slaWithMultipleLimits(int slaId) {
    return new Sla(slaId, asList(tier(), anotherTier()));
  }

  protected Sla anotherSla(int slaId) {
    return new Sla(slaId, asList(anotherTier()));
  }

  private Sla singleLimitSla(int slaId) {
    return new Sla(slaId, asList(tier()));
  }

  private Tier tier() {
    return new SingleTier(10, 1000L);
  }

  private Tier anotherTier() {
    return new SingleTier(33, 55000L);
  }
}
