/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.backoff.mocks;

import static java.util.Arrays.asList;
import static java.util.stream.Collectors.toList;
import static org.junit.Assert.fail;
import static org.mockito.Mockito.RETURNS_DEEP_STUBS;
import static org.mockito.Mockito.mock;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.anypoint.backoff.engine.BackoffSimulation;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.adapter.ApiClientsResponseBuilder;
import com.mulesoft.mule.runtime.gw.client.model.ApiClientsResponse;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.model.Api;

import java.util.ArrayList;
import java.util.List;

public class SimulatedApiPlatformSession implements ApiPlatformSession {

  private final int iteration;
  private final BackoffSimulation simulation;
  private SessionMetadata metadata;

  public SimulatedApiPlatformSession(int iteration, BackoffSimulation simulation) {
    this.iteration = iteration;
    this.simulation = simulation;
    this.metadata = emptyMetadata();
  }

  @Override
  public SessionMetadata metadata() {
    return metadata;
  }

  @Override
  public ApiPlatformSession activateEndpoint(String organizationId, String environmentId, Long apiId) {
    updateMetadataWithSimulation();
    return this;
  }

  @Override
  public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId) {
    return getApiClients(organizationId, environmentId, apiId, null);
  }

  @Override
  public ApiClientsResponse getApiClients(String organizationId, String environmentId, Long apiId, String contractsEntityTag) {
    updateMetadataWithSimulation();
    return new ApiClientsResponseBuilder().withClients(new ArrayList<>()).build();
  }

  @Override
  public ApiResponse getApi(Api api) {
    updateMetadataWithSimulation();
    return mock(ApiResponse.class, RETURNS_DEEP_STUBS);
  }

  @Override
  public ApiResponse getApi(ApiKey apiKey) {
    fail("This method should not have been called");
    return null;
  }

  @Override
  public ApiResponse getApi(ApiKey apiKey, String apiEntityTag) {
    fail("This method should not have been called");
    return null;
  }

  private void updateMetadataWithSimulation() {
    metadata = new SessionMetadata() {

      @Override
      public int requests() {
        return 1;
      }

      @Override
      public List<Integer> statusCodes() {
        return asList(simulation.statusCode(iteration, 200));
      }

      @Override
      public int getCount(int statusCode) {
        return statusCodes().stream()
            .filter(i -> i.equals(statusCode))
            .collect(toList())
            .size();
      }
    };
  }

  private SessionMetadata emptyMetadata() {
    return new SessionMetadata() {

      @Override
      public int requests() {
        return 0;
      }

      @Override
      public List<Integer> statusCodes() {
        return new ArrayList<>();
      }

      @Override
      public int getCount(int statusCode) {
        return 0;
      }
    };
  }

}
