/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.backoff.mocks;

import com.mulesoft.anypoint.backoff.engine.BackoffSimulation;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;

public class SimulatedSessionStatusFactory implements ApiPlatformSessionFactory {

  private final BackoffSimulation simulation;
  private int iteration;

  public SimulatedSessionStatusFactory(BackoffSimulation simulation) {
    this.simulation = simulation;
    this.iteration = 1;
  }

  public SimulatedSessionStatusFactory iteration(int ith) {
    // The ith session (current) will be used to defined the next session status, so it must use the next simulation iteration.
    this.iteration = ith + 1;
    return this;
  }

  @Override
  public ApiPlatformSession create() {
    return new SimulatedApiPlatformSession(iteration, simulation);
  }
}
