/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.pollers;

import static com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration.BACKOFF;
import static com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration.OUTAGE_STATUS_CODES;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKOFF_BASE;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKOFF_DISPERSION;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKOFF_MULTIPLIER;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKOFF_STEPS;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKON_BASE;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKON_DISPERSION;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKON_MULTIPLIER;
import static com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration.DEFAULT_BACKON_STEPS;

import com.mulesoft.anypoint.backoff.function.BoundedExponentialFunction;
import com.mulesoft.anypoint.backoff.function.Round;
import com.mulesoft.anypoint.backoff.function.dispersion.RangeDispersant;

import org.junit.After;
import org.junit.Before;

public abstract class GatewayPollersTestCase {

  @Before
  public void setUp() {
    cleanBackoffSystemProperties();
  }

  @After
  public void tearDown() {
    cleanBackoffSystemProperties();
  }

  private void cleanBackoffSystemProperties() {
    System.clearProperty(OUTAGE_STATUS_CODES);
    System.clearProperty(BACKOFF);
  }

  protected Round defaultBackonFunction() {
    return new Round(new BoundedExponentialFunction(DEFAULT_BACKON_BASE,
                                                    0, DEFAULT_BACKON_STEPS,
                                                    DEFAULT_BACKON_MULTIPLIER,
                                                    new RangeDispersant(DEFAULT_BACKON_DISPERSION, 1.0)));
  }

  protected Round defaultBackoffFunction() {
    return new Round(new BoundedExponentialFunction(DEFAULT_BACKOFF_BASE,
                                                    0, DEFAULT_BACKOFF_STEPS,
                                                    DEFAULT_BACKOFF_MULTIPLIER,
                                                    new RangeDispersant(DEFAULT_BACKOFF_DISPERSION, 1.0)));
  }
}
