/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.mule.runtime.gw.api.service.ContractService;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.deployment.ApiDeploymentCoreExtension;
import com.mulesoft.mule.runtime.gw.deployment.OfflineModeApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.service.DefaultApiService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.RetriableApiTracker;
import com.mulesoft.mule.runtime.gw.metrics.GatewayMetricsAdapter;
import com.mulesoft.mule.runtime.gw.metrics.event.status.ApiRequestsTracker;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.FlexibleGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.HdpApisHealthCheckListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.StrictGateKeeper;
import com.mulesoft.mule.runtime.gw.policies.service.PolicySetDeploymentService;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterCoreExtension;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

@RunWith(value=Parameterized.class)
public class ApiDeploymentCoreExtensionTestCase
extends AbstractMuleTestCase {
    public static final String ENCRYPTION_SYSTEM_PROPERTY = "anypoint.platform.encryption_key";
    @Rule
    public SystemPropertyTemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    @Rule
    public SystemProperty clientId = new SystemProperty("anypoint.platform.client_id", "clientId");
    @Rule
    public SystemProperty clientSecret = new SystemProperty("anypoint.platform.client_secret", "clientSecret");
    private HazelcastClusterManager clusterManager;
    private DeploymentService deploymentService;
    private Registry registry;
    private ApiPlatformClient client;
    private ApiDeploymentCoreExtension coreExtension;

    public ApiDeploymentCoreExtensionTestCase(HazelcastClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({Mockito.mock(HazelcastClusterManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS)}, {null});
    }

    @Before
    public void setUp() {
        HazelcastClusterCoreExtension clusterCoreExtension = (HazelcastClusterCoreExtension)Mockito.mock(HazelcastClusterCoreExtension.class);
        ArtifactClassLoader artifactClassloader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        this.deploymentService = (DeploymentService)Mockito.mock(DeploymentService.class);
        this.registry = (Registry)Mockito.mock(Registry.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.client = (ApiPlatformClient)Mockito.mock(ApiPlatformClient.class);
        Mockito.when((Object)clusterCoreExtension.getHazelcastManager()).thenReturn((Object)this.clusterManager);
        Mockito.when((Object)artifactClassloader.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        this.coreExtension = new ApiDeploymentCoreExtension();
        this.coreExtension.setClusterCoreExtension((ClusterCoreExtension)clusterCoreExtension);
        this.coreExtension.setContainerClassLoader(artifactClassloader);
        this.injectDeploymentService(this.deploymentService);
        this.overrideExtensionLoaded();
        this.overrideContractService();
        this.overridePlatformClient();
    }

    @After
    public void tearDown() {
        System.clearProperty("anypoint.platform.gatekeeper");
        System.clearProperty("anypoint.platform.metrics_enabled");
    }

    @Test
    public void metricsDisabled() throws InitialisationException {
        System.setProperty("anypoint.platform.metrics_enabled", "false");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.instanceOf(HdpApisHealthCheckListener.class), org.hamcrest.Matchers.instanceOf(PolicySetDeploymentService.class), org.hamcrest.Matchers.instanceOf(OfflineModeApiDeploymentListener.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)Matchers.isA(DefaultApiService.class));
    }

    @Test
    public void gateKeeperDisabled() throws InitialisationException {
        System.setProperty("anypoint.platform.gatekeeper", "disabled");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.instanceOf(HdpApisHealthCheckListener.class), org.hamcrest.Matchers.instanceOf(PolicySetDeploymentService.class), org.hamcrest.Matchers.instanceOf(OfflineModeApiDeploymentListener.class), org.hamcrest.Matchers.instanceOf(GatewayMetricsAdapter.class), org.hamcrest.Matchers.instanceOf(ApiRequestsTracker.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)Matchers.isA(DefaultApiService.class));
    }

    @Test
    public void strictGateKeeperEnabled() throws InitialisationException {
        System.setProperty("anypoint.platform.gatekeeper", "strict");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.instanceOf(HdpApisHealthCheckListener.class), org.hamcrest.Matchers.instanceOf(PolicySetDeploymentService.class), org.hamcrest.Matchers.instanceOf(OfflineModeApiDeploymentListener.class), org.hamcrest.Matchers.instanceOf(GatewayMetricsAdapter.class), org.hamcrest.Matchers.instanceOf(ApiRequestsTracker.class)}));
        this.coreExtension.startCoreExtension();
        this.coreExtension.initialiseRestClient();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.hasItem((Matcher)org.hamcrest.Matchers.instanceOf(StrictGateKeeper.class)));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)Matchers.isA(DefaultApiService.class));
    }

    @Test
    public void flexibleGateKeeperEnabled() throws InitialisationException {
        System.setProperty("anypoint.platform.gatekeeper", "flexible");
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.instanceOf(HdpApisHealthCheckListener.class), org.hamcrest.Matchers.instanceOf(PolicySetDeploymentService.class), org.hamcrest.Matchers.instanceOf(OfflineModeApiDeploymentListener.class), org.hamcrest.Matchers.instanceOf(GatewayMetricsAdapter.class), org.hamcrest.Matchers.instanceOf(ApiRequestsTracker.class)}));
        this.coreExtension.startCoreExtension();
        this.coreExtension.initialiseRestClient();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.hasItem((Matcher)org.hamcrest.Matchers.instanceOf(FlexibleGateKeeper.class)));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)Matchers.isA(DefaultApiService.class));
    }

    @Test
    public void flexibleGateKeeperEnabledByDefault() throws InitialisationException {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.instanceOf(HdpApisHealthCheckListener.class), org.hamcrest.Matchers.instanceOf(PolicySetDeploymentService.class), org.hamcrest.Matchers.instanceOf(OfflineModeApiDeploymentListener.class), org.hamcrest.Matchers.instanceOf(GatewayMetricsAdapter.class), org.hamcrest.Matchers.instanceOf(ApiRequestsTracker.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)Matchers.isA(DefaultApiService.class));
        this.coreExtension.startCoreExtension();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.hasItem((Matcher)org.hamcrest.Matchers.instanceOf(FlexibleGateKeeper.class)));
    }

    @Test
    public void onFirstAppDeployed() throws InitialisationException {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishLazyInitialization();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.instanceOf(HdpApisHealthCheckListener.class), org.hamcrest.Matchers.instanceOf(PolicySetDeploymentService.class), org.hamcrest.Matchers.instanceOf(GatewayMetricsAdapter.class), org.hamcrest.Matchers.instanceOf(ApiRequestsTracker.class), org.hamcrest.Matchers.instanceOf(FlexibleGateKeeper.class), org.hamcrest.Matchers.instanceOf(RetriableApiTracker.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)Matchers.isA(DefaultApiService.class));
        List<ApiPlatformClientConnectionListener> connectionListeners = this.getConnectionListeners();
        Assert.assertThat(connectionListeners, (Matcher)org.hamcrest.Matchers.hasSize((int)5));
        Assert.assertThat((Object)connectionListeners.get(0), (Matcher)org.hamcrest.Matchers.instanceOf(PlatformInteractionLifecycle.class));
        Assert.assertThat((Object)connectionListeners.get(1), (Matcher)org.hamcrest.Matchers.instanceOf(PlatformInteractionLifecycle.class));
        Assert.assertThat((Object)connectionListeners.get(2), (Matcher)org.hamcrest.Matchers.instanceOf(PlatformInteractionLifecycle.class));
    }

    @Test
    public void onFirstAppDeployedAndClientInitFailure() throws InitialisationException {
        Mockito.when((Object)this.client.connect()).thenThrow(new Throwable[]{new RuntimeException()});
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishLazyInitialization();
        Assert.assertThat(this.getDeploymentListeners(), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{org.hamcrest.Matchers.instanceOf(HdpApisHealthCheckListener.class), org.hamcrest.Matchers.instanceOf(PolicySetDeploymentService.class), org.hamcrest.Matchers.instanceOf(OfflineModeApiDeploymentListener.class), org.hamcrest.Matchers.instanceOf(GatewayMetricsAdapter.class), org.hamcrest.Matchers.instanceOf(ApiRequestsTracker.class), org.hamcrest.Matchers.instanceOf(FlexibleGateKeeper.class)}));
        ((DeploymentService)Mockito.verify((Object)this.deploymentService)).addDeploymentListener((DeploymentListener)Matchers.isA(DefaultApiService.class));
        List<ApiPlatformClientConnectionListener> connectionListeners = this.getConnectionListeners();
        Assert.assertThat(connectionListeners, (Matcher)org.hamcrest.Matchers.hasSize((int)5));
        Assert.assertThat((Object)connectionListeners.get(0), (Matcher)org.hamcrest.Matchers.instanceOf(PlatformInteractionLifecycle.class));
        Assert.assertThat((Object)connectionListeners.get(1), (Matcher)org.hamcrest.Matchers.instanceOf(PlatformInteractionLifecycle.class));
        Assert.assertThat((Object)connectionListeners.get(2), (Matcher)org.hamcrest.Matchers.instanceOf(PlatformInteractionLifecycle.class));
    }

    @Test
    public void policySetDeploymentServiceRetrierWithNoDelay() throws InitialisationException {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        SchedulingConfiguration retrierSchedulingConfiguration = this.policySetDeploymentServiceRetrierConfiguration();
        Assert.assertThat((Object)retrierSchedulingConfiguration.delay(), (Matcher)org.hamcrest.Matchers.is((Object)Period.millis((long)0L)));
        Assert.assertThat((Object)retrierSchedulingConfiguration.frequency(), (Matcher)org.hamcrest.Matchers.is((Object)Period.millis((long)0L)));
    }

    @Test
    public void policySetDeploymentServiceRetrierThreadName() throws InitialisationException {
        this.coreExtension.initialiseCoreExtension();
        this.coreExtension.finishCoreExtensionInitialization();
        Assert.assertThat((Object)this.retrierThreadName(), (Matcher)org.hamcrest.Matchers.is((Object)"agw-policy-set-deployment"));
    }

    @Test
    public void removeSecretsWhenStoppingRuntime() throws MuleException {
        System.setProperty(ENCRYPTION_SYSTEM_PROPERTY, "GatewayTeamKey00");
        System.setProperty("anypoint.platform.client_secret", "SuperSecretClientSecret");
        this.coreExtension.stop();
        Assert.assertThat((Object)System.getProperty(ENCRYPTION_SYSTEM_PROPERTY, null), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
        Assert.assertThat((Object)System.getProperty("anypoint.platform.client_secret", null), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
    }

    private String retrierThreadName() {
        return (String)new Inspector((Object)this.coreExtension).read("policySetDeploymentService.runnableRetrier.threadName");
    }

    private SchedulingConfiguration policySetDeploymentServiceRetrierConfiguration() {
        return (SchedulingConfiguration)new Inspector((Object)this.coreExtension).read("policySetDeploymentService.runnableRetrier.initialSchedulingConfiguration");
    }

    private List<ApiDeploymentListener> getDeploymentListeners() {
        return (List)new Inspector((Object)this.coreExtension).read("apiService.apiNotificationManager.apiDeploymentListeners");
    }

    private List<ApiPlatformClientConnectionListener> getConnectionListeners() {
        return (List)new Inspector((Object)this.coreExtension).read("clientProvider.connectionListeners");
    }

    private void injectDeploymentService(DeploymentService deploymentService) {
        VariableOverride.overrideVariable((String)"deploymentService").in((Object)this.coreExtension).with((Object)deploymentService);
    }

    private void overridePlatformClient() {
        VariableOverride.overrideVariable((String)"clientProvider.client").in((Object)this.coreExtension).with((Object)this.client);
    }

    private void overrideExtensionLoaded() {
        VariableOverride.overrideVariable((String)"extensionLoaded").in((Object)this.coreExtension).with((Object)true);
    }

    private void overrideContractService() {
        VariableOverride.overrideVariable((String)"contractService").in((Object)this.coreExtension).with(Mockito.mock(ContractService.class));
    }
}

