/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment;

import com.google.common.collect.Lists;
import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.DebugLine;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.autodiscovery.ByIdAutodiscovery;
import com.mulesoft.mule.runtime.gw.autodiscovery.api.Autodiscovery;
import com.mulesoft.mule.runtime.gw.deployment.service.DefaultApiService;
import com.mulesoft.mule.runtime.gw.hdp.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRecordDto;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRegistry;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class ApiServiceTestCase
extends AbstractMuleTestCase {
    @Captor
    private ArgumentCaptor<Api> apiCaptor;
    @Captor
    private ArgumentCaptor<ApiImplementation> implementationCaptor;
    private ApiDeploymentListener deploymentListener;
    private DeploymentService deploymentService;
    private MockLogger logger;
    private DefaultApiService apiService;
    private HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();
    public static final String HDP_APP = "service-mesh";

    @Before
    public void setUp() {
        this.deploymentListener = (ApiDeploymentListener)Mockito.mock(ApiDeploymentListener.class);
        this.deploymentService = (DeploymentService)Mockito.mock(DeploymentService.class);
        this.logger = new MockLogger();
        this.apiService = new DefaultApiService(this.deploymentService);
        VariableOverride.overrideLogger().in((Object)this.apiService).with((Object)this.logger);
    }

    @Test
    public void onDeploymentStart() {
        Registry registry = (Registry)Mockito.mock(Registry.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.injectApiToContext(registry, PolicyTestValuesConstants.API_KEY, PolicyTestValuesConstants.API_KEY_2);
        this.apiService.addDeploymentListener(this.deploymentListener);
        this.apiService.onArtifactInitialised("app", registry);
        Assert.assertThat((Object)this.apiService.isDeployed(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.apiService.isDeployed(PolicyTestValuesConstants.API_KEY_2), (Matcher)Matchers.is((Object)true));
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)2))).onApiDeploymentStart((Api)this.apiCaptor.capture());
        Assert.assertThat((Object)this.apiCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((Api)this.apiCaptor.getAllValues().get(0)).getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.API_KEY));
        Assert.assertThat((Object)((Api)this.apiCaptor.getAllValues().get(1)).getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.API_KEY_2));
    }

    @Test
    public void onDeploymentStartSameApiTwiceSecondIsIgnored() {
        Application application1 = (Application)Mockito.mock(Application.class);
        Application application2 = (Application)Mockito.mock(Application.class);
        Registry registry1 = (Registry)Mockito.mock(Registry.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Registry registry2 = (Registry)Mockito.mock(Registry.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.injectApiToContext(registry1, PolicyTestValuesConstants.API_KEY);
        this.injectApiToContext(registry2, PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)this.deploymentService.findApplication("app")).thenReturn((Object)application1);
        Mockito.when((Object)this.deploymentService.findApplication("app2")).thenReturn((Object)application2);
        this.apiService.onArtifactInitialised("app", registry1);
        this.apiService.onArtifactInitialised("app2", registry2);
        Assert.assertThat((Object)this.apiService.isDeployed(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ApiImplementation)this.apiService.getImplementation(PolicyTestValuesConstants.API_KEY).get()).getArtifactName(), (Matcher)Matchers.is((Object)application1.getArtifactName()));
    }

    @Test
    public void onDeploymentSuccess() {
        this.initialiseApiService();
        this.apiService.onDeploymentSuccess("app");
        Assert.assertThat((Object)this.apiService.isDeployed(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.is((Object)true));
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)1))).onApiDeploymentSuccess((Api)this.apiCaptor.capture());
        Assert.assertThat((Object)this.apiCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((Api)this.apiCaptor.getAllValues().get(0)).getKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.API_KEY));
    }

    @Test
    public void onUndeploymentStart() {
        this.initialiseApiService();
        Api spiedApi = this.spyApi();
        this.apiService.onUndeploymentStart("app");
        Assert.assertThat((Object)this.apiService.isDeployed(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.is((Object)false));
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)1))).onApiUndeploymentStart((ApiImplementation)this.implementationCaptor.capture());
        Assert.assertThat((Object)this.implementationCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ApiImplementation)this.implementationCaptor.getAllValues().get(0)).getApiKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.API_KEY));
        ((Api)Mockito.verify((Object)spiedApi)).dispose();
        Assert.assertThat(this.logger.lines().get(this.logger.lines().size() - 1), (Matcher)Matchers.is((Object)new DebugLine("API {} un-deployment started", new Object[]{spiedApi})));
    }

    @Test
    public void apiIsRemovedFromServiceAfterNotifyingListeners() {
        Application application = this.injectApplication("app");
        ApiDeploymentListener mockListener = new ApiDeploymentListener(){

            public void onApiUndeploymentStart(ApiImplementation implementation) {
                Assert.assertThat((Object)ApiServiceTestCase.this.apiService.get(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.not(Optional.empty()));
            }
        };
        this.apiService.addDeploymentListener(mockListener);
        this.apiService.onArtifactInitialised("app", application.getRegistry());
        this.apiService.onUndeploymentStart("app");
    }

    @Test
    public void onRedeploymentStart() {
        this.initialiseApiService();
        Api spiedApi = this.spyApi();
        this.apiService.onRedeploymentStart("app");
        this.assertRedeploy(spiedApi);
    }

    @Test
    public void onRedeployUndeployNotificationDoesNotFire() {
        this.initialiseApiService();
        Api spiedApi = this.spyApi();
        this.apiService.onRedeploymentStart("app");
        this.apiService.onUndeploymentStart("app");
        this.assertRedeploy(spiedApi);
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)0))).onApiUndeploymentStart((ApiImplementation)org.mockito.Matchers.any());
    }

    @Test
    public void onHdpApiUpdateCreate() {
        this.createHdpApis();
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)2))).onApiDeploymentSuccess((Api)this.apiCaptor.capture());
        Assert.assertThat((Object)this.apiCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((Api)this.apiCaptor.getAllValues().get(0)).getKey().id(), (Matcher)Matchers.is((Object)1001L));
        Assert.assertThat(((Api)this.apiCaptor.getAllValues().get(0)).getImplementation().getHdpService().orElse(null), (Matcher)Matchers.is((Object)"one"));
        Assert.assertThat((Object)((Api)this.apiCaptor.getAllValues().get(1)).getKey().id(), (Matcher)Matchers.is((Object)1002L));
        Assert.assertThat(((Api)this.apiCaptor.getAllValues().get(1)).getImplementation().getHdpService().orElse(null), (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    public void onHdpApiUpdateRemove() {
        ApiRegistry apiRegistry = this.createHdpApis();
        apiRegistry.getApiRecords().remove(0);
        this.apiService.updateHdpApis(apiRegistry);
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)1))).onApiUndeploymentStart((ApiImplementation)this.implementationCaptor.capture());
        Assert.assertThat((Object)this.implementationCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ApiImplementation)this.implementationCaptor.getAllValues().get(0)).getApiKey().id(), (Matcher)Matchers.is((Object)1001L));
    }

    @Test
    public void onHdpApiUpdateRenameService() {
        ApiRegistry apiRegistry = this.createHdpApis();
        apiRegistry.getApiRecords().remove(1);
        apiRegistry.getApiRecords().add(new ApiRecordDto(1002L, "two-renamed"));
        this.apiService.updateHdpApis(apiRegistry);
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)1))).onApiUndeploymentStart((ApiImplementation)this.implementationCaptor.capture());
        Assert.assertThat((Object)this.implementationCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ApiImplementation)this.implementationCaptor.getAllValues().get(0)).getApiKey().id(), (Matcher)Matchers.is((Object)1002L));
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)3))).onApiDeploymentSuccess((Api)this.apiCaptor.capture());
        Assert.assertThat((Object)this.apiCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((Api)this.apiCaptor.getAllValues().get(2)).getKey().id(), (Matcher)Matchers.is((Object)1002L));
        Assert.assertThat(((Api)this.apiCaptor.getAllValues().get(2)).getImplementation().getHdpService().orElse(null), (Matcher)Matchers.is((Object)"two-renamed"));
    }

    private ApiRegistry createHdpApis() {
        this.apiService.addDeploymentListener(this.deploymentListener);
        Application application = this.injectHdpApplication();
        Mockito.when((Object)application.getRegistry().lookupByName("hdp-apis-healthcheck")).thenReturn(Optional.empty());
        this.apiService.onDeploymentSuccess(HDP_APP);
        ArrayList<ApiRecordDto> apis = new ArrayList<ApiRecordDto>();
        apis.add(new ApiRecordDto(1001L, "one"));
        apis.add(new ApiRecordDto(1002L, "two"));
        ApiRegistry apiRegistry = new ApiRegistry(HDP_APP, apis);
        this.apiService.updateHdpApis(apiRegistry);
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)2))).onApiDeploymentStart((Api)org.mockito.Matchers.any());
        return apiRegistry;
    }

    private void initialiseApiService() {
        Application application = this.injectApplication("app");
        this.apiService.addDeploymentListener(this.deploymentListener);
        this.apiService.onArtifactInitialised("app", application.getRegistry());
    }

    private void assertRedeploy(Api spiedApi) {
        Assert.assertThat((Object)this.apiService.isDeployed(PolicyTestValuesConstants.API_KEY), (Matcher)Matchers.is((Object)false));
        ((ApiDeploymentListener)Mockito.verify((Object)this.deploymentListener, (VerificationMode)Mockito.times((int)1))).onApiRedeploymentStart((ApiImplementation)this.implementationCaptor.capture());
        Assert.assertThat((Object)this.implementationCaptor.getAllValues(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ApiImplementation)this.implementationCaptor.getAllValues().get(0)).getApiKey(), (Matcher)Matchers.is((Object)PolicyTestValuesConstants.API_KEY));
        ((Api)Mockito.verify((Object)spiedApi, (VerificationMode)Mockito.times((int)0))).dispose();
        Assert.assertThat(this.logger.lines().get(this.logger.lines().size() - 1), (Matcher)Matchers.is((Object)new DebugLine("API {} re-deployment started", new Object[]{spiedApi})));
    }

    private Api spyApi() {
        Map<ApiKey, Api> serviceApis = this.peekApis(this.apiService);
        Api spiedApi = (Api)Mockito.spy((Object)serviceApis.get(PolicyTestValuesConstants.API_KEY));
        serviceApis.put(PolicyTestValuesConstants.API_KEY, spiedApi);
        return spiedApi;
    }

    private Map<ApiKey, Api> peekApis(DefaultApiService apiService) {
        return (Map)new Inspector((Object)apiService).read("apis");
    }

    private Application injectHdpApplication() {
        Application application = this.injectApplication(HDP_APP);
        ConfigurationProperties config = (ConfigurationProperties)Mockito.mock(ConfigurationProperties.class);
        Mockito.when((Object)config.resolveBooleanProperty(this.hdpConfiguration.getHdpApplicationProperty())).thenReturn(Optional.of(true));
        Mockito.when((Object)application.getRegistry().lookupByType(ConfigurationProperties.class)).thenReturn(Optional.of(config));
        return application;
    }

    private Application injectApplication(String appName) {
        Application application = (Application)Mockito.mock(Application.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.injectApiToContext(application.getRegistry(), PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)this.deploymentService.findApplication(appName)).thenReturn((Object)application);
        Mockito.when((Object)application.getArtifactName()).thenReturn((Object)appName);
        Mockito.when((Object)application.getRegistry().lookupByType(ConfigurationProperties.class)).thenReturn(Optional.empty());
        return application;
    }

    private void injectApiToContext(Registry registry, ApiKey ... apiKeys) {
        List metadatas = Lists.newArrayList((Object[])apiKeys).stream().map(apiKey -> {
            ByIdAutodiscovery metadata = new ByIdAutodiscovery();
            metadata.setId(apiKey.id());
            return metadata;
        }).collect(Collectors.toList());
        Mockito.when((Object)registry.lookupAllByType(Autodiscovery.class)).thenReturn((Object)Lists.newArrayList(metadatas));
        Mockito.when((Object)registry.lookupByType(Flow.class)).thenReturn(Optional.of(Mockito.mock(Flow.class)));
    }
}

