/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.NoSla;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.client.dto.ApiClientDto;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.deployment.ApiPlatformTestCase;
import com.mulesoft.mule.runtime.gw.deployment.contracts.ContractSnapshots;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.DefaultClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class ContractSnapshotsTestCase
extends ApiPlatformTestCase {
    static final List<Contract> EMPTY_UPDATE = new ArrayList<Contract>();
    private static final Long INEXISTENT_API_ID = 100L;
    ContractSnapshots snapshots;
    Lock lock;
    @Captor
    private ArgumentCaptor<List<Contract>> captor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mocks.singleTrackedApi();
        this.lock = (Lock)Mockito.mock(Lock.class);
        this.snapshots = new ContractSnapshots(this.mocks.apiService(), this.lock, (ClientFactory)new DefaultClientFactory());
        ApiContracts apiContracts = this.mocks.api().getContracts();
        Mockito.when((Object)apiContracts.contractsLoaded()).thenReturn((Object)true);
        Mockito.when((Object)this.mocks.apiService().get(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.of(this.mocks.api()));
        Mockito.when((Object)this.mocks.apiService().getContracts(PolicyTestValuesConstants.API_KEY)).thenReturn(Optional.ofNullable(apiContracts));
        Mockito.when((Object)this.mocks.apiService().getContracts(this.inexistentApi())).thenReturn(Optional.empty());
        Mockito.when((Object)this.mocks.apiService().get(this.inexistentApi())).thenReturn(Optional.empty());
    }

    void checkContractsUpdates(List<Contract> ... expectedUpdates) {
        this.checkContractsUpdates(this.mocks.api(), expectedUpdates);
    }

    void checkContractsUpdates(Api api, List<Contract> ... expectedUpdates) {
        int contractsCount = expectedUpdates.length;
        ((ApiContracts)Mockito.verify((Object)api.getContracts(), (VerificationMode)Mockito.times((int)contractsCount))).updateContracts((List)this.captor.capture());
        MatcherAssert.assertThat((Object)this.captor.getAllValues(), (Matcher)Matchers.hasSize((int)contractsCount));
        for (int i = 0; i < contractsCount; ++i) {
            MatcherAssert.assertThat((String)("Failed on list ith=" + i), this.captor.getAllValues().get(i), (Matcher)Matchers.is(expectedUpdates[i]));
        }
    }

    void verifyApiTestInvocations() {
        ((Api)Mockito.verify((Object)this.mocks.api(), (VerificationMode)Mockito.times((int)3))).getTrackingInfo();
        ((Api)Mockito.verify((Object)this.mocks.api(), (VerificationMode)Mockito.times((int)3))).getImplementation();
        ((Api)Mockito.verify((Object)this.mocks.api(), (VerificationMode)Mockito.atLeastOnce())).getContracts();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mocks.api()});
    }

    Contract contractMultiLimit(int anotherTierId) {
        return this.contract(this.slaWithMultipleLimits(anotherTierId), this.client(anotherTierId));
    }

    Contract contractSingleLimit(int slaId) {
        return this.contract(this.sla(slaId), this.client(slaId));
    }

    Contract noSlaContractForAnotherClient(String slaId) {
        return Contract.builder().withClient(this.anotherClient(slaId)).withSla((Sla)new NoSla()).build();
    }

    Contract noSlaContractForAnotherClient(int slaId) {
        return this.noSlaContractForAnotherClient(Integer.toString(slaId));
    }

    Contract noSlaContractForClient(String slaId) {
        return Contract.builder().withClient(this.client(slaId)).build();
    }

    Contract noSlaContractForClient(int slaId) {
        return this.noSlaContractForClient(Integer.toString(slaId));
    }

    Contract noSlaContractForThirdClient(int slaId) {
        return Contract.builder().withClient(this.aThirdClient(slaId)).withSla((Sla)new NoSla()).build();
    }

    protected Contract contract(Sla sla, Client client) {
        return Contract.builder().withClient(client).withSla(sla).build();
    }

    protected Client client(int slaId) {
        return this.client(Integer.toString(slaId));
    }

    protected Client client(String slaId) {
        return this.client(0, slaId);
    }

    protected Client client(int id, int slaId) {
        return this.client(id, Integer.toString(slaId));
    }

    protected Client client(int id, String slaId) {
        return this.validClient(this.platformContractAdapterFromDto(this.dtoClient(id, 1L, slaId)));
    }

    protected Client anotherClient(int slaId) {
        return this.anotherClient(Integer.toString(slaId));
    }

    protected Client anotherClient(String slaId) {
        return this.validClient(this.platformContractAdapterFromDto(this.dtoClient(1, 2L, slaId)));
    }

    protected Client aThirdClient(int slaId) {
        return this.validClient(this.platformContractAdapterFromDto(this.dtoClient(2, 2L, Integer.toString(slaId))));
    }

    protected ApiKey inexistentApi() {
        return new ApiKey(INEXISTENT_API_ID);
    }

    protected PlatformContractAdapter platformContractAdapterFromDto(ApiClientDto client) {
        return new PlatformContractAdapter(client);
    }

    protected PlatformContractAdapter platformContractAdapter(int slaId) {
        return this.platformContractAdapter(Integer.toString(slaId));
    }

    protected PlatformContractAdapter platformContractAdapter(String slaId) {
        return this.platformContractAdapter(0, slaId);
    }

    protected PlatformContractAdapter platformContractAdapter(int id, String slaId) {
        return this.platformContractAdapterFromDto(this.dtoClient(id, 1L, slaId));
    }

    protected PlatformContractAdapter anotherPlatformContractAdapter(int slaId) {
        return this.anotherPlatformContractAdapter(Integer.toString(slaId));
    }

    protected PlatformContractAdapter anotherPlatformContractAdapter(String slaId) {
        return this.platformContractAdapterFromDto(this.dtoClient(1, 2L, slaId));
    }

    protected PlatformContractAdapter aThirdPlatformContractAdapter(int slaId) {
        return this.platformContractAdapterFromDto(this.dtoClient(2, 2L, Integer.toString(slaId)));
    }

    private Client validClient(PlatformContractAdapter platformContractAdapter) {
        return new DefaultClientFactory().create(platformContractAdapter.clientId(), platformContractAdapter.clientSecret(), platformContractAdapter.clientName());
    }
}

