/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.service;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.client.ClientsRepositoryException;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.dto.CoreServicesClientDto;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.response.PlatformResponse;
import com.mulesoft.mule.runtime.gw.deployment.service.CoreServicesClientsRepository;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CoreServicesClientsRepositoryTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String CLIENT_ID = "id";
    private static final String CLIENT_SECRET = "secret";
    private static final String PATCH_NAME = "<placeholder>";
    private ApiPlatformClient platform;
    private CoreServicesClientsRepository repository;
    private CoreServicesClientDto dto;

    @Before
    public void setUp() {
        this.platform = (ApiPlatformClient)Mockito.mock(ApiPlatformClient.class);
        this.repository = new CoreServicesClientsRepository(this.platform);
        this.dto = new CoreServicesClientDto(CLIENT_ID, CLIENT_SECRET, "name", null, null);
    }

    @Test
    public void canNotGetClientJustWithId() throws ClientsRepositoryException {
        this.thrown.expect(ClientsRepositoryException.class);
        this.thrown.expectMessage(String.format("Can not retrieve client using only client id. Please check you have patch '%s' correctly applied.", PATCH_NAME));
        this.repository.getBy(CLIENT_ID);
    }

    @Test
    public void successfulGetClient() throws ClientsRepositoryException {
        IntStream.range(200, 299).forEach(statusCode -> {
            Mockito.when((Object)this.platform.getClient((String)Matchers.eq((Object)CLIENT_ID), (String)Matchers.eq((Object)CLIENT_SECRET))).thenReturn((Object)new PlatformResponse((Object)this.dto, statusCode));
            try {
                MatcherAssert.assertThat((Object)this.repository.getBy(CLIENT_ID, CLIENT_SECRET), (Matcher)org.hamcrest.Matchers.is((Object)this.adapt(this.dto)));
            }
            catch (ClientsRepositoryException e) {
                Assert.fail((String)"Exception was raised.");
            }
        });
    }

    @Test
    public void errorStatusCode() {
        IntStream.range(400, 600).forEach(statusCode -> {
            Mockito.when((Object)this.platform.getClient((String)Matchers.eq((Object)CLIENT_ID), (String)Matchers.eq((Object)CLIENT_SECRET))).thenReturn((Object)new PlatformResponse((Object)this.dto, statusCode));
            boolean exceptionRaised = false;
            try {
                this.repository.getBy(CLIENT_ID, CLIENT_SECRET);
            }
            catch (ClientsRepositoryException e) {
                exceptionRaised = true;
                MatcherAssert.assertThat((Object)e.getStatus(), (Matcher)org.hamcrest.Matchers.is((Object)statusCode));
                MatcherAssert.assertThat((Object)e.toString(), (Matcher)org.hamcrest.Matchers.is((Object)String.format("Invalid client with id '%s'. (%s).", CLIENT_ID, statusCode)));
            }
            if (!exceptionRaised) {
                Assert.fail((String)("Exception was not raised for status code " + statusCode));
            }
        });
    }

    @Test
    public void platformException() throws ClientsRepositoryException {
        int statusCode = 404;
        HttpResponseException responseException = (HttpResponseException)Mockito.mock(HttpResponseException.class);
        Mockito.when((Object)responseException.statusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)this.platform.getClient(Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{responseException});
        this.thrown.expect(ClientsRepositoryException.class);
        this.thrown.expectMessage(String.format("Invalid client with id '%s'.", CLIENT_ID));
        this.repository.getBy(CLIENT_ID, CLIENT_SECRET);
    }

    @Test
    public void connectionException() throws ClientsRepositoryException {
        int statusCode = 404;
        String message = "message";
        HttpResponseException responseException = (HttpResponseException)Mockito.mock(HttpConnectionException.class);
        Mockito.when((Object)responseException.statusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)responseException.getMessage()).thenReturn((Object)message);
        Mockito.when((Object)this.platform.getClient(Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{responseException});
        this.thrown.expect(ClientsRepositoryException.class);
        this.thrown.expectMessage(String.format("Invalid client with id '%s'.", CLIENT_ID));
        this.repository.getBy(CLIENT_ID, CLIENT_SECRET);
    }

    private Client adapt(CoreServicesClientDto dto) {
        return Client.builder().withId(dto.getId()).withName(dto.getName()).withSecret(dto.getSecret()).build();
    }
}

