/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.client.session.factory.RestClientApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.ApisPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis.ApisPlatformInteractionLifecycleFactory;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.ClientsPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients.ClientsPlatformInteractionLifecycleFactory;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.KeepAlivePlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive.KeepAlivePlatformInteractionLifecycleFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.retry.BackoffRunnableRetrierFactory;

public class PlatformInteractionServicesLifecycleFactory {

  private final ApisPlatformInteractionLifecycleFactory apisPlatformInteractionLifecycleFactory;
  private final ClientsPlatformInteractionLifecycleFactory clientsPlatformInteractionLifecycleFactory;
  private final KeepAlivePlatformInteractionLifecycleFactory keepAlivePlatformInteractionLifecycleFactory;

  public PlatformInteractionServicesLifecycleFactory() {
    this.apisPlatformInteractionLifecycleFactory = new ApisPlatformInteractionLifecycleFactory();
    this.clientsPlatformInteractionLifecycleFactory = new ClientsPlatformInteractionLifecycleFactory();
    this.keepAlivePlatformInteractionLifecycleFactory = new KeepAlivePlatformInteractionLifecycleFactory();
  }

  public PlatformInteractionServicesLifecycle create(ApiService apiService,
                                                     ApiTrackingService apiTrackingService,
                                                     ApiPlatformClientProvider clientProvider,
                                                     BackoffSchedulerFactory schedulerFactory,
                                                     BackoffConfigurationSupplier backoffConfigurationSupplier,
                                                     BackoffRunnableRetrierFactory backoffRunnableRetrierFactory,
                                                     boolean standaloneOrPrimaryNode) {

    GatewayConfiguration configuration = new GatewayConfiguration();
    ApiPlatformSessionFactory restPlatformSessionFactory = new RestClientApiPlatformSessionFactory(clientProvider.getClient());

    ApisPlatformInteractionLifecycle apisPlatformInteractionLifecycle = apisPlatformInteractionLifecycleFactory
        .create(configuration, standaloneOrPrimaryNode, apiService, apiTrackingService, clientProvider,
                restPlatformSessionFactory,
                schedulerFactory, backoffConfigurationSupplier, backoffRunnableRetrierFactory);

    ClientsPlatformInteractionLifecycle clientsPlatformInteractionLifecycle = clientsPlatformInteractionLifecycleFactory
        .create(configuration, apiService, apiTrackingService, clientProvider, restPlatformSessionFactory, schedulerFactory,
                backoffConfigurationSupplier);

    KeepAlivePlatformInteractionLifecycle keepAlivePlatformInteractionLifecycle =
        keepAlivePlatformInteractionLifecycleFactory
            .create(configuration, standaloneOrPrimaryNode, apiTrackingService, clientProvider, restPlatformSessionFactory,
                    schedulerFactory, backoffConfigurationSupplier);

    return new PlatformInteractionServicesLifecycle(apisPlatformInteractionLifecycle,
                                                    keepAlivePlatformInteractionLifecycle,
                                                    clientsPlatformInteractionLifecycle);
  }


}
