/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.apis;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.client.exception.RecoverableExceptionMessageLogger;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.client.session.factory.FileSystemApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PrimaryPollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTracker;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.deployment.tracking.RetriableApiTracker;
import com.mulesoft.mule.runtime.gw.retry.BackoffRunnableRetrierFactory;

public class ApisPlatformInteractionLifecycleFactory {

  public ApisPlatformInteractionLifecycle create(GatewayConfiguration configuration, boolean standaloneOrPrimaryNode,
                                                 ApiService apiService, ApiTrackingService apiTrackingService,
                                                 ApiPlatformClientProvider clientProvider,
                                                 ApiPlatformSessionFactory restPlatformSessionFactory,
                                                 BackoffSchedulerFactory schedulerFactory,
                                                 BackoffConfigurationSupplier configurationSupplier,
                                                 BackoffRunnableRetrierFactory backoffRunnableRetrierFactory) {

    switch (configuration.platformServices().apisInfoSource()) {
      case POLLING:
        return polling(configuration, standaloneOrPrimaryNode, apiService, apiTrackingService,
                       clientProvider, restPlatformSessionFactory, schedulerFactory,
                       configurationSupplier, backoffRunnableRetrierFactory);
      case FILE_SYSTEM:
        return fileSystem(configuration, apiService, apiTrackingService);
      default:
        return new DisabledApisPlatformInteractionLifecycle();
    }
  }

  private ApisPlatformInteractionLifecycle fileSystem(GatewayConfiguration configuration,
                                                      ApiService apiService,
                                                      ApiTrackingService apiTrackingService) {

    ApiPlatformSessionFactory sessionFactory =
        new FileSystemApiPlatformSessionFactory(configuration.platformServices().apisFolder().get());
    ApiTracker apiTracker = new ApiTracker(apiTrackingService, sessionFactory);
    return new ApisFileSystemPlatformInteractionLifecycle(apiService, apiTracker);
  }

  private ApisPlatformInteractionLifecycle polling(GatewayConfiguration configuration,
                                                   boolean standaloneOrPrimaryNode,
                                                   ApiService apiService,
                                                   ApiTrackingService apiTrackingService,
                                                   ApiPlatformClientProvider clientProvider,
                                                   ApiPlatformSessionFactory restPlatformSessionFactory,
                                                   BackoffSchedulerFactory schedulerFactory,
                                                   BackoffConfigurationSupplier configurationSupplier,
                                                   BackoffRunnableRetrierFactory backoffRunnableRetrierFactory) {

    RetriableApiTracker apiTracker = new RetriableApiTracker(
                                                             new ApiTracker(apiTrackingService, restPlatformSessionFactory,
                                                                            RecoverableExceptionMessageLogger::new),
                                                             backoffRunnableRetrierFactory.apiTrackerRetrier());

    GatewayApisPoller poller = new GatewayApisPoller(configuration, apiTrackingService, restPlatformSessionFactory,
                                                     schedulerFactory, configurationSupplier);

    PollerPlatformInteractionLifecycle pollerLifecycle = new PollerPlatformInteractionLifecycle(poller);

    PrimaryPollerPlatformInteractionLifecycle primaryLifecycle =
        new PrimaryPollerPlatformInteractionLifecycle(pollerLifecycle, standaloneOrPrimaryNode);

    ApisPollerPlatformInteractionLifecycle lifecycle =
        new ApisPollerPlatformInteractionLifecycle(primaryLifecycle, apiService, apiTracker);

    clientProvider.addConnectionListener(lifecycle);

    return lifecycle;
  }

}
