/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.clients;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientProvider;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PollerPlatformInteractionLifecycle;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;

public class ClientsPlatformInteractionLifecycleFactory {

  public ClientsPlatformInteractionLifecycle create(GatewayConfiguration configuration, ApiService apiService,
                                                    ApiTrackingService apiTrackingService,
                                                    ApiPlatformClientProvider clientProvider,
                                                    ApiPlatformSessionFactory restPlatformSessionFactory,
                                                    BackoffSchedulerFactory schedulerFactory,
                                                    BackoffConfigurationSupplier backoffConfigurationSupplier) {

    if (configuration.platformServices().getClientsPollEnabled()) {
      PlatformClientsRetriever retriever = new PlatformClientsRetriever(restPlatformSessionFactory, apiTrackingService);

      apiService.addApiContractsListener(retriever);

      GatewayClientsPoller pollerManager = new GatewayClientsPoller(configuration, apiTrackingService,
                                                                    restPlatformSessionFactory, schedulerFactory,
                                                                    backoffConfigurationSupplier, retriever);

      ClientsPlatformInteractionLifecycleAdapter lifecycle =
          new ClientsPlatformInteractionLifecycleAdapter(new PollerPlatformInteractionLifecycle(pollerManager));

      clientProvider.addConnectionListener(lifecycle);

      return lifecycle;
    }

    return new DisabledClientsPlatformInteractionLifecycle();
  }
}
