/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.seconds;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.GatewayPoller;
import com.mulesoft.mule.runtime.gw.deployment.runnable.ApiKeepAliveRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;

public class GatewayKeepAlivePoller extends GatewayPoller {

  private final ApiTrackingService apiTrackingService;
  private final ApiPlatformSessionFactory platformSessionFactory;


  public GatewayKeepAlivePoller(GatewayConfiguration configuration,
                                ApiTrackingService apiTrackingService,
                                ApiPlatformSessionFactory platformSessionFactory,
                                BackoffSchedulerFactory schedulerFactory,
                                BackoffConfigurationSupplier backoffConfigurationSupplier) {
    super("agw-api-keep-alive", configuration, schedulerFactory, backoffConfigurationSupplier);
    this.apiTrackingService = apiTrackingService;
    this.platformSessionFactory = platformSessionFactory;
  }

  @Override
  protected BackoffRunnable runnable(BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration) {
    return new ApiKeepAliveRunnable(apiTrackingService,
                                    platformSessionFactory,
                                    backoffBarrier,
                                    backoffConfiguration);
  }

  @Override
  public SchedulingConfiguration configuration() {
    return SchedulingConfiguration.configuration(seconds(0), configuration.platformClient().getApiKeepAliveFrequency());
  }

}
