/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import org.mule.runtime.api.lifecycle.Disposable;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.anypoint.retry.RunnableRetrier;

public class RetriableApiTracker implements ApiDeploymentListener, Disposable {

  private final RunnableRetrier<ApiKey> runnableRetrier;
  private final ApiTracker apiTacker;

  public RetriableApiTracker(ApiTracker apiTracker, RunnableRetrier<ApiKey> runnableRetrier) {
    this.apiTacker = apiTracker;
    this.runnableRetrier = runnableRetrier;
  }

  @Override
  public void onApiDeploymentSuccess(Api api) {
    try {
      apiTacker.onApiDeploymentSuccess(api);
    } catch (Throwable t) {
      scheduleRetry(api);
    }
  }

  private void scheduleRetry(Api api) {
    runnableRetrier.scheduleRetry(api.getKey(), () -> this.onApiDeploymentSuccess(api));
  }

  @Override
  public void dispose() {
    runnableRetrier.dispose();
  }

}
