/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.NoSla;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.deployment.contracts.Snapshot;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ContractSnapshot
implements Snapshot {
    private Optional<Map<Integer, Sla>> slas = Optional.empty();
    private Optional<List<Contract>> contracts = Optional.empty();
    private final ClientFactory clientFactory;

    public ContractSnapshot(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public ContractSnapshot(List<Contract> storedContracts, ClientFactory clientFactory) {
        this.contracts = Optional.of(storedContracts);
        this.slas = Optional.of(storedContracts.stream().map(Contract::sla).filter(sla -> sla.id() != 0).distinct().collect(Collectors.toMap(Sla::id, sla -> sla)));
        this.clientFactory = clientFactory;
    }

    @Override
    public Optional<List<Contract>> contracts() {
        return this.contracts.map(list -> list.stream().map(contract -> this.newContract(contract.client(), this.slas.map(slas -> (Sla)slas.getOrDefault(contract.sla().id(), new NoSla())).orElse((Sla)new NoSla()))).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Sla>> slas() {
        return this.slas.map(map -> new ArrayList(map.values()));
    }

    @Override
    public Snapshot platformSlas(List<Sla> platformSlas) {
        this.contracts = this.contracts.map(list -> list.stream().filter(contract -> this.hasMatchingSla((Contract)contract, platformSlas)).collect(Collectors.toList()));
        this.slas = Optional.of(platformSlas.stream().collect(Collectors.toMap(Sla::id, sla -> sla)));
        return this;
    }

    @Override
    public Snapshot platformContracts(List<PlatformContractAdapter> platformContractAdapters) {
        this.contracts = Optional.of(platformContractAdapters.stream().map(contract -> this.newContract(this.clientFactory.create(contract.clientId(), contract.clientSecret(), contract.clientName()), (Sla)(contract.slaId().isPresent() ? new Sla((Integer)contract.slaId().get(), new Tier[0]) : new NoSla()))).collect(Collectors.toList()));
        return this;
    }

    private boolean hasMatchingSla(Contract contract, List<Sla> platformSlas) {
        return contract.sla().id() == 0 || platformSlas.stream().anyMatch(platformSla -> platformSla.id().equals(contract.sla().id()));
    }

    private Contract newContract(Client client, Sla sla) {
        return Contract.builder().withClient(client).withSla(sla).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractSnapshot that = (ContractSnapshot)o;
        if (this.slas != null ? !this.slas.equals(that.slas) : that.slas != null) {
            return false;
        }
        return this.contracts != null ? this.contracts.equals(that.contracts) : that.contracts == null;
    }

    public int hashCode() {
        int result = this.slas != null ? this.slas.hashCode() : 0;
        result = 31 * result + (this.contracts != null ? this.contracts.hashCode() : 0);
        return result;
    }
}

