/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.service;

import com.mulesoft.mule.runtime.gw.api.client.ClientsRepository;
import com.mulesoft.mule.runtime.gw.api.client.ClientsRepositoryException;
import com.mulesoft.mule.runtime.gw.api.client.CoreServicesClient;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.client.dto.CoreServicesClientDto;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.response.PlatformResponse;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreServicesClientsRepository
implements ClientsRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreServicesClientsRepository.class);
    private static final String PATCH_NAME = "<placeholder>";
    private ApiPlatformClient platform;

    public CoreServicesClientsRepository(ApiPlatformClient platform) {
        Objects.requireNonNull(platform, String.format("%s is null, cannot create the %s", ApiPlatformClient.class.getSimpleName(), CoreServicesClientsRepository.class.getSimpleName()));
        this.platform = platform;
    }

    public CoreServicesClient getBy(String id) throws ClientsRepositoryException {
        throw new ClientsRepositoryException(String.format("Can not retrieve client using only client id. Please check you have patch '%s' correctly applied.", PATCH_NAME), 400);
    }

    public CoreServicesClient getBy(String id, String secret) throws ClientsRepositoryException {
        try {
            PlatformResponse platformResponse = this.platform.getClient(id, secret);
            if (platformResponse.statusCode() >= 400) {
                throw new ClientsRepositoryException(String.format("Invalid client with id '%s'.", id), platformResponse.statusCode());
            }
            CoreServicesClientDto dto = (CoreServicesClientDto)platformResponse.entity();
            return CoreServicesClient.getBuilder().withId(dto.getId()).withSecret(dto.getSecret()).withName(dto.getName()).withRedirectionUris(dto.getRedirectUris()).build();
        }
        catch (HttpConnectionException e) {
            LOGGER.error("There was a connection error while looking for client with id '{}'. Cause: {}.", (Object)id, (Object)e.getMessage());
            throw new ClientsRepositoryException(String.format("Invalid client with id '%s'.", id), e.statusCode());
        }
        catch (HttpResponseException e) {
            LOGGER.error("Invalid status code returned, {}, when looking for client with id '{}'.", (Object)e.statusCode(), (Object)id);
            throw new ClientsRepositoryException(String.format("Invalid client with id '%s'.", id), e.statusCode());
        }
    }
}

