/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction.keepalive;

import com.mulesoft.mule.runtime.gw.client.provider.ApiPlatformClientConnectionListener;
import com.mulesoft.mule.runtime.gw.deployment.platform.interaction.PrimaryPollerPlatformInteractionLifecycle;

public class KeepAlivePlatformInteractionLifecycleAdapter implements KeepAlivePlatformInteractionLifecycle,
    ApiPlatformClientConnectionListener {

  private PrimaryPollerPlatformInteractionLifecycle lifecycle;

  public KeepAlivePlatformInteractionLifecycleAdapter(PrimaryPollerPlatformInteractionLifecycle lifecycle) {
    this.lifecycle = lifecycle;
  }

  @Override
  public void onClientConnected() {
    this.lifecycle.onClientConnected();
  }

  @Override
  public void primaryNode() {
    this.lifecycle.primaryNode();
  }

  @Override
  public void dispose() {
    this.lifecycle.dispose();
  }
}
